/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.client.okhttp.repo.utils;

import com.google.common.base.Joiner;
import io.getstream.client.model.filters.FeedFilter;
import io.getstream.client.okhttp.repo.utils.UriBuilder;

public class FeedFilterUtils {
    private FeedFilterUtils() {
        throw new AssertionError();
    }

    public static UriBuilder apply(UriBuilder uriBuilder, FeedFilter filter) {
        if (null != filter.getLimit()) {
            uriBuilder.queryParam("limit", filter.getLimit());
        }
        if (null != filter.getOffset()) {
            uriBuilder.queryParam("offset", filter.getOffset());
        }
        if (null != filter.getIdGreaterThan()) {
            uriBuilder.queryParam("id_gt", filter.getIdGreaterThan());
        }
        if (null != filter.getIdGreaterThanEquals()) {
            uriBuilder.queryParam("id_gte", filter.getIdGreaterThanEquals());
        }
        if (null != filter.getIdLowerThan()) {
            uriBuilder.queryParam("id_lt", filter.getIdLowerThan());
        }
        if (null != filter.getIdLowerThanEquals()) {
            uriBuilder.queryParam("id_lte", filter.getIdLowerThanEquals());
        }
        if (null != filter.getFeedIds()) {
            uriBuilder.queryParam("filter", Joiner.on((String)",").join((Iterable)filter.getFeedIds()));
        }
        return uriBuilder;
    }
}

