/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.client.okhttp.repo.utils;

import com.squareup.okhttp.Request;
import io.getstream.client.model.feeds.BaseFeed;
import io.getstream.client.okhttp.repo.utils.SignatureUtils;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;

public class StreamRepoUtils {
    private StreamRepoUtils() {
        throw new AssertionError();
    }

    public static Request.Builder addAuthentication(BaseFeed feed, String secretKey, Request.Builder httpRequest) {
        httpRequest.addHeader("Authorization", StreamRepoUtils.createFeedSignature(feed, secretKey));
        return httpRequest;
    }

    public static String createFeedToken(BaseFeed feed, String secretKey) {
        try {
            return SignatureUtils.calculateHMAC(secretKey, feed.getFeedId());
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new RuntimeException("Fatal error: cannot create authentication token.");
        }
    }

    public static String createFeedSignature(BaseFeed feed, String secretKey) {
        String token = StreamRepoUtils.createFeedToken(feed, secretKey);
        return String.format("%s %s", feed.getFeedId(), token);
    }
}

