/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.client.okhttp.repo;

import com.google.common.base.Optional;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import io.getstream.client.config.AuthenticationHandlerConfiguration;
import io.getstream.client.util.HttpSignatureHandler;
import java.io.IOException;
import java.util.Collections;
import org.tomitribe.auth.signatures.Signature;

public class HttpSignatureinterceptor
extends HttpSignatureHandler
implements Interceptor {
    public HttpSignatureinterceptor(AuthenticationHandlerConfiguration authConfig) {
        super(authConfig);
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Optional appAuthHeader = Optional.fromNullable((Object)request.header("X-Api-Key"));
        if (appAuthHeader.isPresent()) {
            Request.Builder newRequest = request.newBuilder();
            String today = this.getTodayDate();
            newRequest.addHeader("Date", today);
            Signature signature = this.getSigner().sign(request.method(), request.urlString(), Collections.singletonMap("Date", today));
            newRequest.addHeader("Authorization", signature.toString());
            request = newRequest.build();
        }
        return chain.proceed(request);
    }
}

