/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.client.okhttp.repo;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import io.getstream.client.exception.StreamClientException;
import io.getstream.client.model.activities.AggregatedActivity;
import io.getstream.client.model.activities.BaseActivity;
import io.getstream.client.model.activities.NotificationActivity;
import io.getstream.client.model.beans.AddMany;
import io.getstream.client.model.beans.MarkedActivity;
import io.getstream.client.model.beans.StreamActivitiesResponse;
import io.getstream.client.model.beans.StreamResponse;
import io.getstream.client.model.feeds.BaseFeed;
import io.getstream.client.model.filters.FeedFilter;
import io.getstream.client.okhttp.repo.handlers.StreamExceptionHandler;
import io.getstream.client.okhttp.repo.utils.FeedFilterUtils;
import io.getstream.client.okhttp.repo.utils.SignatureUtils;
import io.getstream.client.okhttp.repo.utils.StreamRepoUtils;
import io.getstream.client.okhttp.repo.utils.UriBuilder;
import io.getstream.client.util.JwtAuthenticationUtil;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamActivityRepository {
    private static final Logger LOG = LoggerFactory.getLogger(StreamActivityRepository.class);
    private static final String APPLICATION_JSON = "application/json; charset=utf-8";
    private final ObjectMapper objectMapper;
    private final URI baseEndpoint;
    private final String apiKey;
    private final StreamExceptionHandler exceptionHandler;
    private final OkHttpClient httpClient;
    private final String secretKey;

    public StreamActivityRepository(ObjectMapper objectMapper, URI baseEndpoint, String apiKey, StreamExceptionHandler exceptionHandler, OkHttpClient httpClient, String secretKey) {
        this.objectMapper = objectMapper;
        this.baseEndpoint = baseEndpoint;
        this.apiKey = apiKey;
        this.exceptionHandler = exceptionHandler;
        this.httpClient = httpClient;
        this.secretKey = secretKey;
    }

    public <T extends BaseActivity> T addActivity(BaseFeed feed, T activity) throws StreamClientException, IOException {
        Request.Builder requestBuilder = new Request.Builder().url(UriBuilder.fromEndpoint(this.baseEndpoint).path("feed").path(feed.getFeedSlug()).path(feed.getUserId() + "/").queryParam("api_key", this.apiKey).build().toURL());
        SignatureUtils.addSignatureToRecipients(this.secretKey, activity);
        requestBuilder.post(RequestBody.create((MediaType)MediaType.parse((String)APPLICATION_JSON), (String)this.objectMapper.writeValueAsString(activity)));
        Request request = this.addAuthentication(feed, requestBuilder).build();
        LOG.debug("Invoking url: '{}", (Object)request.urlString());
        Response response = this.httpClient.newCall(request).execute();
        this.handleResponseCode(response);
        return (T)((BaseActivity)this.objectMapper.readValue(response.body().byteStream(), this.objectMapper.getTypeFactory().constructType(activity.getClass())));
    }

    public <T extends BaseActivity> StreamActivitiesResponse<T> addActivities(BaseFeed feed, Class<T> type, List<T> activities) throws StreamClientException, IOException {
        Request.Builder requestBuilder = new Request.Builder().url(UriBuilder.fromEndpoint(this.baseEndpoint).path("feed").path(feed.getFeedSlug()).path(feed.getUserId() + "/").queryParam("api_key", this.apiKey).build().toURL());
        for (BaseActivity activity : activities) {
            SignatureUtils.addSignatureToRecipients(this.secretKey, activity);
        }
        requestBuilder.post(RequestBody.create((MediaType)MediaType.parse((String)APPLICATION_JSON), (String)this.objectMapper.writeValueAsString(Collections.singletonMap("activities", activities))));
        Request request = this.addAuthentication(feed, requestBuilder).build();
        LOG.debug("Invoking url: '{}", (Object)request.urlString());
        Response response = this.httpClient.newCall(request).execute();
        this.handleResponseCode(response);
        return (StreamActivitiesResponse)this.objectMapper.readValue(response.body().byteStream(), this.objectMapper.getTypeFactory().constructParametricType(StreamActivitiesResponse.class, new Class[]{type}));
    }

    public <T extends BaseActivity> T addToMany(List<String> targetIds, T activity) throws StreamClientException, IOException {
        Request.Builder requestBuilder = new Request.Builder().url(UriBuilder.fromEndpoint(this.baseEndpoint).path("feed").path("add_to_many/").queryParam("api_key", this.apiKey).build().toURL());
        requestBuilder.addHeader("X-Api-Key", this.apiKey);
        requestBuilder.post(RequestBody.create((MediaType)MediaType.parse((String)APPLICATION_JSON), (String)this.objectMapper.writeValueAsString((Object)new AddMany(targetIds, activity))));
        Request request = requestBuilder.build();
        LOG.debug("Invoking url: '{}", (Object)request.urlString());
        Response response = this.httpClient.newCall(request).execute();
        this.handleResponseCode(response);
        return (T)((BaseActivity)this.objectMapper.readValue(response.body().byteStream(), this.objectMapper.getTypeFactory().constructType(activity.getClass())));
    }

    public <T extends BaseActivity> StreamResponse<T> getActivities(BaseFeed feed, Class<T> type, FeedFilter filter) throws IOException, StreamClientException {
        Request.Builder requestBuilder = new Request.Builder().url(FeedFilterUtils.apply(UriBuilder.fromEndpoint(this.baseEndpoint).path("feed").path(feed.getFeedSlug()).path(feed.getUserId() + "/").queryParam("api_key", this.apiKey), filter).build().toURL()).get();
        Request request = this.addAuthentication(feed, requestBuilder).build();
        LOG.debug("Invoking url: '{}", (Object)request.urlString());
        Response response = this.httpClient.newCall(request).execute();
        this.handleResponseCode(response);
        return (StreamResponse)this.objectMapper.readValue(response.body().byteStream(), this.objectMapper.getTypeFactory().constructParametricType(StreamResponse.class, new Class[]{type}));
    }

    public <T extends BaseActivity> StreamResponse<AggregatedActivity<T>> getAggregatedActivities(BaseFeed feed, Class<T> type, FeedFilter filter) throws IOException, StreamClientException {
        Request.Builder requestBuilder = new Request.Builder().url(FeedFilterUtils.apply(UriBuilder.fromEndpoint(this.baseEndpoint).path("feed").path(feed.getFeedSlug()).path(feed.getUserId() + "/").queryParam("api_key", this.apiKey), filter).build().toURL()).get();
        Request request = this.addAuthentication(feed, requestBuilder).build();
        LOG.debug("Invoking url: '{}", (Object)request.urlString());
        Response response = this.httpClient.newCall(request).execute();
        this.handleResponseCode(response);
        return (StreamResponse)this.objectMapper.readValue(response.body().byteStream(), this.objectMapper.getTypeFactory().constructParametricType(StreamResponse.class, new JavaType[]{this.objectMapper.getTypeFactory().constructParametricType(AggregatedActivity.class, new Class[]{type})}));
    }

    public <T extends BaseActivity> StreamResponse<NotificationActivity<T>> getNotificationActivities(BaseFeed feed, Class<T> type, FeedFilter filter) throws IOException, StreamClientException {
        Request.Builder requestBuilder = new Request.Builder().url(FeedFilterUtils.apply(UriBuilder.fromEndpoint(this.baseEndpoint).path("feed").path(feed.getFeedSlug()).path(feed.getUserId() + "/").queryParam("api_key", this.apiKey), filter).build().toURL()).get();
        Request request = this.addAuthentication(feed, requestBuilder).build();
        LOG.debug("Invoking url: '{}", (Object)request.urlString());
        Response response = this.httpClient.newCall(request).execute();
        this.handleResponseCode(response);
        return (StreamResponse)this.objectMapper.readValue(response.body().byteStream(), this.objectMapper.getTypeFactory().constructParametricType(StreamResponse.class, new JavaType[]{this.objectMapper.getTypeFactory().constructParametricType(NotificationActivity.class, new Class[]{type})}));
    }

    public <T extends BaseActivity> StreamResponse<NotificationActivity<T>> getNotificationActivities(BaseFeed feed, Class<T> type, FeedFilter filter, boolean markAsRead, boolean markAsSeen) throws IOException, StreamClientException {
        Request.Builder requestBuilder = new Request.Builder().url(FeedFilterUtils.apply(UriBuilder.fromEndpoint(this.baseEndpoint).path("feed").path(feed.getFeedSlug()).path(feed.getUserId() + "/").queryParam("api_key", this.apiKey).queryParam("mark_read", Boolean.toString(markAsRead)).queryParam("mark_seen", Boolean.toString(markAsSeen)), filter).build().toURL()).get();
        Request request = this.addAuthentication(feed, requestBuilder).build();
        LOG.debug("Invoking url: '{}", (Object)request.urlString());
        Response response = this.httpClient.newCall(request).execute();
        this.handleResponseCode(response);
        return (StreamResponse)this.objectMapper.readValue(response.body().byteStream(), this.objectMapper.getTypeFactory().constructParametricType(StreamResponse.class, new JavaType[]{this.objectMapper.getTypeFactory().constructParametricType(NotificationActivity.class, new Class[]{type})}));
    }

    public <T extends BaseActivity> StreamResponse<NotificationActivity<T>> getNotificationActivities(BaseFeed feed, Class<T> type, FeedFilter filter, MarkedActivity markAsRead, MarkedActivity markAsSeen) throws IOException, StreamClientException {
        UriBuilder baseUri = UriBuilder.fromEndpoint(this.baseEndpoint).path("feed").path(feed.getFeedSlug()).path(feed.getUserId() + "/").queryParam("api_key", this.apiKey);
        if (null != markAsRead && markAsRead.hasActivities()) {
            baseUri.queryParam("mark_read", markAsRead.joinActivities());
        }
        if (null != markAsSeen && markAsSeen.hasActivities()) {
            baseUri.queryParam("mark_seen", markAsSeen.joinActivities());
        }
        Request.Builder requestBuilder = new Request.Builder().url(FeedFilterUtils.apply(baseUri, filter).build().toURL()).get();
        Request request = this.addAuthentication(feed, requestBuilder).build();
        LOG.debug("Invoking url: '{}", (Object)request.urlString());
        Response response = this.httpClient.newCall(request).execute();
        this.handleResponseCode(response);
        return (StreamResponse)this.objectMapper.readValue(response.body().byteStream(), this.objectMapper.getTypeFactory().constructParametricType(StreamResponse.class, new JavaType[]{this.objectMapper.getTypeFactory().constructParametricType(NotificationActivity.class, new Class[]{type})}));
    }

    public void deleteActivityById(BaseFeed feed, String activityId) throws IOException, StreamClientException {
        Request.Builder requestBuilder = new Request.Builder().delete().url(UriBuilder.fromEndpoint(this.baseEndpoint).path("feed").path(feed.getFeedSlug()).path(feed.getUserId()).path(activityId + "/").queryParam("api_key", this.apiKey).build().toURL());
        Request request = this.addAuthentication(feed, requestBuilder).build();
        LOG.debug("Invoking url: '{}", (Object)request.urlString());
        Response response = this.httpClient.newCall(request).execute();
        this.handleResponseCode(response);
    }

    public void deleteActivityByForeignId(BaseFeed feed, String activityId) throws IOException, StreamClientException {
        Request.Builder requestBuilder = new Request.Builder().delete().url(UriBuilder.fromEndpoint(this.baseEndpoint).path("feed").path(feed.getFeedSlug()).path(feed.getUserId()).path(activityId + "/").queryParam("foreign_id", Boolean.toString(true)).queryParam("api_key", this.apiKey).build().toURL());
        Request request = this.addAuthentication(feed, requestBuilder).build();
        LOG.debug("Invoking url: '{}", (Object)request.urlString());
        Response response = this.httpClient.newCall(request).execute();
        this.handleResponseCode(response);
    }

    public <T extends BaseActivity> StreamActivitiesResponse<T> updateActivities(BaseFeed feed, Class<T> type, List<T> activities) throws IOException, StreamClientException {
        Request.Builder requestBuilder = new Request.Builder().delete().url(UriBuilder.fromEndpoint(this.baseEndpoint).path("activities/").queryParam("api_key", this.apiKey).build().toURL());
        requestBuilder.post(RequestBody.create((MediaType)MediaType.parse((String)APPLICATION_JSON), (byte[])this.objectMapper.writeValueAsBytes(Collections.singletonMap("activities", activities))));
        Request request = StreamRepoUtils.addJwtAuthentication(JwtAuthenticationUtil.generateToken((String)this.secretKey, (String)"activities", (String)"*", (String)"*", null), requestBuilder).build();
        LOG.debug("Invoking url: '{}", (Object)request.urlString());
        Response response = this.httpClient.newCall(request).execute();
        this.handleResponseCode(response);
        return (StreamActivitiesResponse)this.objectMapper.readValue(response.body().byteStream(), this.objectMapper.getTypeFactory().constructParametricType(StreamActivitiesResponse.class, new Class[]{type}));
    }

    private void handleResponseCode(Response response) throws StreamClientException, IOException {
        this.exceptionHandler.handleResponseCode(response);
    }

    private Request.Builder addAuthentication(BaseFeed feed, Request.Builder httpRequest) {
        return StreamRepoUtils.addAuthentication(feed, this.secretKey, httpRequest);
    }
}

