/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.client.okhttp.repo.utils;

import com.squareup.okhttp.Request;
import io.getstream.client.model.feeds.BaseFeed;
import io.getstream.client.okhttp.repo.utils.SignatureUtils;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;

public class StreamRepoUtils {
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String HEADER_AUTH_TYPE = "stream-auth-type";

    private StreamRepoUtils() {
        throw new AssertionError();
    }

    public static Request.Builder addAuthentication(BaseFeed feed, String secretKey, Request.Builder httpRequest) {
        httpRequest.addHeader(HEADER_AUTHORIZATION, StreamRepoUtils.createFeedSignature(feed, secretKey));
        return httpRequest;
    }

    public static String createFeedToken(BaseFeed feed, String secretKey) {
        try {
            return SignatureUtils.calculateHMAC(secretKey, feed.getFeedId());
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new RuntimeException("Fatal error: cannot create authentication token.");
        }
    }

    public static String createFeedSignature(BaseFeed feed, String secretKey) {
        String token = StreamRepoUtils.createFeedToken(feed, secretKey);
        return String.format("%s %s", feed.getFeedId(), token);
    }

    public static Request.Builder addJwtAuthentication(String token, Request.Builder requestBuilder) {
        requestBuilder.addHeader(HEADER_AUTHORIZATION, token);
        requestBuilder.addHeader(HEADER_AUTH_TYPE, "jwt");
        return requestBuilder;
    }
}

