

package com.docuware.dev.schema._public.services.platform;

import com.docuware.dev.Extensions.CompareIgnore;

import javax.xml.bind.annotation.*;
import java.util.ArrayList;
import java.util.List;


@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ViewerPreferences", propOrder = {
    "annotations",
    "toolbars"
})
@CompareIgnore
public class ViewerPreferences  {

    @XmlElement(name = "Annotations", required = true)
    protected ViewerPreferences.Annotations annotations;
    @XmlElement(name = "Toolbars", required = true)
    protected ViewerPreferences.Toolbars toolbars;
    @XmlAttribute(name = "Id", required = true)
    protected String id;
    @XmlAttribute(name = "LeftToolbarState", required = true)
    protected ToolbarVisibility leftToolbarState;
    @XmlAttribute(name = "RightToolbarState", required = true)
    protected ToolbarVisibility rightToolbarState;
    @XmlAttribute(name = "ExpandStatusbar", required = true)
    protected boolean expandStatusbar;

    public ViewerPreferences.Annotations getAnnotations() {
        return annotations;
    }

    public void setAnnotations(ViewerPreferences.Annotations value) {
        this.annotations = value;
    }

    public ViewerPreferences.Toolbars getToolbars() {
        return toolbars;
    }

    public void setToolbars(ViewerPreferences.Toolbars value) {
        this.toolbars = value;
    }

    /**The ID of the Viewer preferences.*/
    public String getId() {
        return id;
    }

    /**The ID of the Viewer preferences.*/
    public void setId(String value) {
        this.id = value;
    }

    public ToolbarVisibility getLeftToolbarState() {
        return leftToolbarState;
    }

    public void setLeftToolbarState(ToolbarVisibility value) {
        this.leftToolbarState = value;
    }

    public ToolbarVisibility getRightToolbarState() {
        return rightToolbarState;
    }

    public void setRightToolbarState(ToolbarVisibility value) {
        this.rightToolbarState = value;
    }

    public boolean isExpandStatusbar() {
        return expandStatusbar;
    }

    public void setExpandStatusbar(boolean value) {
        this.expandStatusbar = value;
    }


    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "annotationTool"
    })
    public static class Annotations {

        @XmlElement(name = "AnnotationTool")
        protected List<AnnotationToolSettings> annotationTool;

    /**ArrayList is required for the XML-Marshalling */
    public void setAnnotationTool(ArrayList<AnnotationToolSettings> value) {
        annotationTool=value;
    }

        public List<AnnotationToolSettings> getAnnotationTool() {
            if (annotationTool == null) {
                annotationTool = new ArrayList<AnnotationToolSettings>();
            }
            return this.annotationTool;
        }

    }


    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "toolbar"
    })
    public static class Toolbars {

        @XmlElement(name = "Toolbar")
        protected List<ViewerToolbar> toolbar;

    /**ArrayList is required for the XML-Marshalling */
    public void setToolbar(ArrayList<ViewerToolbar> value) {
        toolbar=value;
    }

        public List<ViewerToolbar> getToolbar() {
            if (toolbar == null) {
                toolbar = new ArrayList<ViewerToolbar>();
            }
            return this.toolbar;
        }

    }



}
