package com.shsnc.shsncrocket.ImportSelector;

import com.shsnc.shsncrocket.ShsncRocketConfiguration;
import com.shsnc.shsncrocket.core.annotation.EnableSncLog;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.type.AnnotationMetadata;

import java.util.Map;

public class SncLogImportSelector implements ImportSelector {

    @Override
    public String[] selectImports(AnnotationMetadata metadata) {
        Map<String, Object> attributes = metadata
                .getAnnotationAttributes(EnableSncLog.class.getName());
        boolean enabled = (boolean) attributes.get("enabled");
        if (enabled) {
            return new String[]{ShsncRocketConfiguration.class.getName()};
        } else {
            return new String[]{};
        }
    }
}
