package com.shsnc.shsncrocket.aspectj;

import com.shsnc.shsncrocket.core.rocketmq.RocketMQEnhanceTemplate;
import lombok.Setter;
import org.springframework.aop.aspectj.AspectJExpressionPointcutAdvisor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ConfigurableAdvisorConfig {

    @Value("${snc.log.pointcut}")
    private String pointcut;

    @Autowired
    @Qualifier("shsncRocketMQEnhanceTemplate")
    private RocketMQEnhanceTemplate rocketMQEnhanceTemplate;

    @Bean
    public AspectJExpressionPointcutAdvisor configurabledvisor() {
        //声明一个aspectj切点,一张切面
        AspectJExpressionPointcutAdvisor advisor = new AspectJExpressionPointcutAdvisor();
        // 设置切点表达式
        advisor.setExpression(pointcut);
        //
        advisor.setAdvice(new SncOperLogAspect(rocketMQEnhanceTemplate));
        return advisor;
    }
}
