package com.shsnc.shsncrocket.core;

import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.shsnc.shsncrocket.core.rocketmq.EnhanceRocketMQConfig;
import com.shsnc.shsncrocket.core.rocketmq.RocketMQEnhanceTemplate;
import com.shsnc.shsncrocket.core.rocketmq.message.ApiLogMessage;
import lombok.extern.slf4j.Slf4j;
import com.shsnc.shsncrocket.entiy.ApiLog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;

/**
 * 调用第三方接口日志记录
 */
@Component
@Slf4j
public class CallApiLogHandler {

    @Autowired
    private RocketMQEnhanceTemplate rocketMQEnhanceTemplate;

    public void apiLog(String interfaceName,
                       String method, String httpStatus,
                       String url, String result,
                       String params, String maintenanceCompany,
                       String description, Integer type) {
        LocalDateTime now = LocalDateTime.now();
        ThreadUtil.execute(() -> {
            ApiLog apiLog = new ApiLog();
            apiLog.setInterfaceName(interfaceName);
            apiLog.setMethod(method);
            apiLog.setHttpStatus(httpStatus);
            apiLog.setUrl(url);
            apiLog.setResult(result);
            apiLog.setParams(StrUtil.sub(params, 0, 2000));
            apiLog.setMaintenanceCompany(maintenanceCompany);
            apiLog.setDescription(description);
            apiLog.setCreateTime(now);
            apiLog.setType(type);
            apiLog.setIsSuccess(StrUtil.isBlank(description));
            //发送日志到mq
            ApiLogMessage<ApiLog> apiLogApiLogMessage = new ApiLogMessage<>();
            apiLogApiLogMessage.setApiLog(apiLog);
            rocketMQEnhanceTemplate.send(EnhanceRocketMQConfig.getApiLogTopicName(), apiLogApiLogMessage);
        });
    }

    public static void apiLogHandle(String interfaceName,
                                    String method, String httpStatus,
                                    String url, String result,
                                    String params, String maintenanceCompany,
                                    String description, Integer type) {
        CallApiLogHandler bean = SpringUtil.getBean(CallApiLogHandler.class);
        if (bean == null) {
            log.warn("CallApiLogHandler is null");
            return;
        }
        bean.apiLog(interfaceName, method, httpStatus, url, result, params, maintenanceCompany, description, type);
    }
}
