package com.shsnc.shsncrocket.core;

import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.http.useragent.UserAgent;
import cn.hutool.http.useragent.UserAgentUtil;
import com.shsnc.shsncrocket.core.rocketmq.EnhanceRocketMQConfig;
import com.shsnc.shsncrocket.core.rocketmq.RocketMQEnhanceTemplate;
import com.shsnc.shsncrocket.core.rocketmq.message.SncLoginMessage;
import com.shsnc.shsncrocket.entiy.SncLoginLog;
import com.shsnc.shsncrocket.util.ServletUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import java.time.LocalDateTime;

@Component
public class SncLoginLogHandler {

    @Autowired
    private RocketMQEnhanceTemplate rocketMQEnhanceTemplate;

    /**
     * 登录日志记录
     *
     * @param userName 用户名
     * @param status   状态 （1成功 0失败）
     * @param msg      登录时返回的消息（成功或失败消息）
     */
    public void loginLog(String userName, String status, String msg) {
        HttpServletRequest request = ServletUtils.getRequest();
        LocalDateTime now = LocalDateTime.now();
        ThreadUtil.execute(() -> {
            UserAgent userAgent = UserAgentUtil.parse(request.getHeader("User-Agent"));
            SncLoginLog sncLoginLog = new SncLoginLog();
            sncLoginLog.setLoginTime(now);
            String clientIP = ServletUtils.getClientIP(request);
            sncLoginLog.setIpaddr(clientIP);
            sncLoginLog.setBrowser(userAgent.getBrowser().getName());
            sncLoginLog.setStatus(status);
            sncLoginLog.setMsg(msg);
            sncLoginLog.setOs(userAgent.getOs().getName());
            SncLoginMessage<SncLoginLog> sncLoginMessage = new SncLoginMessage<>();
            sncLoginMessage.setSncLoginLog(sncLoginLog);
            sncLoginMessage.setSystemName(EnhanceRocketMQConfig.getSystemName());
            rocketMQEnhanceTemplate.send(EnhanceRocketMQConfig.getLoginLogTopicName(), sncLoginMessage);
        });
    }
}
