package com.shsnc.shsncrocket.core.rocketmq;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotNull;

@Component
@ConfigurationProperties(prefix = "rocketmq.enhance")
public class EnhanceRocketMQConfig {

    private static String operLogTopicName = "rocket_enhance_shsnc_log_center_oper_log";

    private static String loginLogTopicName = "rocket_enhance_shsnc_log_center_login_log";

    private static String apiLogTopicName = "rocket_enhance_shsnc_log_center_api_log";

    @NotNull
    private static String systemName;

    public static String getOperLogTopicName() {
        return operLogTopicName;
    }

    public void setOperLogTopicName(String operLogTopicName) {
        EnhanceRocketMQConfig.operLogTopicName = operLogTopicName;
    }

    public static String getLoginLogTopicName() {
        return loginLogTopicName;
    }

    public void setLoginLogTopicName(String loginLogTopicName) {
        EnhanceRocketMQConfig.loginLogTopicName = loginLogTopicName;
    }

    public static String getSystemName() {
        return systemName;
    }

    public void setSystemName(String systemName) {
        EnhanceRocketMQConfig.systemName = systemName;
    }

    public static String getApiLogTopicName() {
        return apiLogTopicName;
    }
}
