/*
 * Decompiled with CFR 0.152.
 */
package com.aluka.nirvana.framework.security.configuration;

import cn.hutool.core.util.ArrayUtil;
import com.aluka.nirvana.framework.security.configuration.SecurityCustomsConfiguration;
import com.aluka.nirvana.framework.security.handler.CustomAuthAccessDeniedHandler;
import com.aluka.nirvana.framework.security.handler.CustomAuthenticationEntryPointHandler;
import com.aluka.nirvana.framework.security.handler.CustomAuthenticationFailureHandler;
import com.aluka.nirvana.framework.security.handler.CustomAuthenticationSuccessHandler;
import com.aluka.nirvana.framework.security.handler.CustomLogoutSuccessHandler;
import com.aluka.nirvana.framework.security.handler.CustomTokenAuthenticationHandler;
import com.aluka.nirvana.framework.security.provider.AuthenticationValidProvider;
import com.aluka.nirvana.framework.security.provider.DefaultAuthenticationProvider;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

@Configuration
@EnableWebSecurity
@EnableConfigurationProperties(value={SecurityCustomsConfiguration.class})
@EnableGlobalMethodSecurity(prePostEnabled=true)
public class SecurityConfiguration
extends WebSecurityConfigurerAdapter {
    @Autowired
    private SecurityCustomsConfiguration customsConfiguration;
    @Autowired
    private CustomAuthenticationSuccessHandler customAuthenticationSuccessHandler;
    @Autowired
    private CustomAuthenticationFailureHandler customAuthenticationFailureHandler;
    @Autowired
    private CustomLogoutSuccessHandler customLogoutSuccessHandler;
    @Autowired
    private CustomAuthAccessDeniedHandler customAuthAccessDeniedHandler;
    @Autowired
    private CustomAuthenticationEntryPointHandler customAuthenticationEntryPointHandler;
    @Autowired(required=false)
    private AuthenticationValidProvider authenticationValidProvider;

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    @ConditionalOnMissingBean(value={AuthenticationProvider.class})
    public AuthenticationProvider defaultAuthenticationProvider() {
        return new DefaultAuthenticationProvider();
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        auth.authenticationProvider((AuthenticationProvider)this.getApplicationContext().getBean(AuthenticationProvider.class));
    }

    protected void configure(HttpSecurity http) throws Exception {
        ArrayList openResources = Lists.newArrayList((Object[])this.customsConfiguration.getOpenResources().split(","));
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers((String[])ArrayUtil.toArray((Collection)openResources, String.class))).permitAll().anyRequest()).authenticated().and()).httpBasic().authenticationEntryPoint((AuthenticationEntryPoint)this.customAuthenticationEntryPointHandler).and()).formLogin().loginProcessingUrl(this.customsConfiguration.getLoginUrl())).successHandler((AuthenticationSuccessHandler)this.customAuthenticationSuccessHandler)).failureHandler((AuthenticationFailureHandler)this.customAuthenticationFailureHandler)).and()).logout().logoutUrl(this.customsConfiguration.getLogoutUrl()).logoutSuccessHandler((LogoutSuccessHandler)this.customLogoutSuccessHandler).and()).exceptionHandling().accessDeniedHandler((AccessDeniedHandler)this.customAuthAccessDeniedHandler).and()).csrf().disable();
        http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
        http.headers().cacheControl();
        openResources.add(this.customsConfiguration.getLoginUrl());
        openResources.add(this.customsConfiguration.getLogoutUrl());
        CustomTokenAuthenticationHandler authenticationHandler = new CustomTokenAuthenticationHandler(this.authenticationManager());
        authenticationHandler.setOpenResources((String[])ArrayUtil.toArray((Collection)openResources, String.class));
        authenticationHandler.setAuthenticationValidProvider(this.authenticationValidProvider);
        authenticationHandler.setAuthenticationValidEnabled(this.customsConfiguration.isAuthenticationValidEnabled());
        http.addFilter((Filter)authenticationHandler);
    }
}

