/*
 * Decompiled with CFR 0.152.
 */
package com.aluka.nirvana.framework.security.handler;

import com.aluka.nirvana.framework.security.configuration.SecurityCustomsConfiguration;
import com.aluka.nirvana.framework.security.principal.AuthenticationSuccessResponse;
import com.aluka.nirvana.framework.security.principal.BaseUserDetails;
import com.aluka.nirvana.framework.security.utils.JwtUtils;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.stereotype.Component;

@Component
public class CustomAuthenticationSuccessHandler
implements AuthenticationSuccessHandler {
    @Autowired
    private SecurityCustomsConfiguration customsConfiguration;

    public void onAuthenticationSuccess(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Authentication authentication) throws IOException, ServletException {
        Calendar calendar = Calendar.getInstance();
        calendar.add(10, this.customsConfiguration.getTokenExpire());
        BaseUserDetails userDetails = (BaseUserDetails)authentication.getPrincipal();
        String loginSuccessCustomFields = this.customsConfiguration.getLoginSuccessCustomFields();
        String token = JwtUtils.create(userDetails, calendar.getTime(), loginSuccessCustomFields);
        AuthenticationSuccessResponse response = new AuthenticationSuccessResponse();
        response.setStatus(HttpStatus.OK.value());
        response.setMessage("\u767b\u5f55\u6210\u529f!");
        response.setToken("nirvana: " + token);
        response.setScope(userDetails.getAuthorities());
        response.setExpire(calendar.getTime().getTime());
        response.setCustomField(this.bindCustomField(userDetails));
        httpServletResponse.setContentType("application/json;charset=UTF-8");
        httpServletResponse.setCharacterEncoding("UTF-8");
        httpServletResponse.getWriter().write(response.toString());
    }

    private Map<String, Object> bindCustomField(BaseUserDetails userDetails) {
        HashMap customFields = Maps.newHashMap();
        String loginSuccessCustomFields = this.customsConfiguration.getLoginSuccessCustomFields();
        for (String customField : StringUtils.split((String)loginSuccessCustomFields, (String)",")) {
            Object customFieldValue = userDetails.getCustomField(customField);
            if (customFieldValue == null) continue;
            customFields.put(customField, customFieldValue);
        }
        return customFields;
    }
}

