/*
 * Decompiled with CFR 0.152.
 */
package com.aluka.nirvana.framework.security.handler;

import cn.hutool.core.exceptions.ExceptionUtil;
import com.aluka.nirvana.framework.security.principal.BaseUserDetails;
import com.aluka.nirvana.framework.security.provider.AuthenticationValidProvider;
import com.aluka.nirvana.framework.security.utils.ResponseUtils;
import com.google.common.base.Throwables;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import java.io.IOException;
import java.util.HashSet;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.util.AntPathMatcher;

public class CustomTokenAuthenticationHandler
extends BasicAuthenticationFilter {
    private static final Logger log = LoggerFactory.getLogger(CustomTokenAuthenticationHandler.class);
    private String[] openResources;
    private AuthenticationValidProvider authenticationValidProvider;
    private boolean authenticationValidEnabled;

    public CustomTokenAuthenticationHandler(AuthenticationManager authenticationManager) {
        super(authenticationManager);
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        block8: {
            if (this.intercept(request)) {
                String tokenHeader = request.getHeader("Authorization");
                if (StringUtils.isEmpty((CharSequence)tokenHeader) || !tokenHeader.startsWith("nirvana: ")) {
                    ResponseUtils.writeResponse(response, HttpStatus.FORBIDDEN, "Token \u4e0d\u5b58\u5728!");
                } else {
                    try {
                        String token = tokenHeader.replace("nirvana: ", "");
                        Claims claims = (Claims)Jwts.parser().setSigningKey("nirvanaCommonSecret").parseClaimsJws(token).getBody();
                        BaseUserDetails userDetails = this.parseClaims(claims);
                        if (this.handlerRequest(request, userDetails)) {
                            UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)userDetails, (Object)userDetails.getUsername(), userDetails.getAuthorities());
                            SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
                            chain.doFilter((ServletRequest)request, (ServletResponse)response);
                            break block8;
                        }
                        ResponseUtils.writeResponse(response, HttpStatus.UNAUTHORIZED, "\u6682\u65e0\u6743\u9650\u8bbf\u95ee\u6b64\u529f\u80fd!");
                    }
                    catch (ExpiredJwtException e) {
                        ResponseUtils.writeResponse(response, HttpStatus.FORBIDDEN, "Token \u5df2\u8fc7\u671f!");
                        log.warn("Token \u5df2\u8fc7\u671f!");
                    }
                    catch (Exception e) {
                        ResponseUtils.writeResponse(response, HttpStatus.FORBIDDEN, "Token \u65e0\u6548!");
                        log.warn("Token \u89e3\u6790\u5931\u8d25 >> {}", (Object)ExceptionUtil.stacktraceToString((Throwable)Throwables.getRootCause((Throwable)e), (int)255));
                    }
                }
            } else {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        }
    }

    private boolean handlerRequest(HttpServletRequest request, BaseUserDetails userDetails) {
        return userDetails.isAdmin() || !this.authenticationValidEnabled || this.isOpen(request.getRequestURI()) || this.authenticationValidProvider == null || this.authenticationValidProvider.valid(userDetails, request.getRequestURI());
    }

    private boolean isOpen(String url) {
        AntPathMatcher pathMatcher = new AntPathMatcher();
        for (String openResource : this.openResources) {
            if (!pathMatcher.match(openResource, url)) continue;
            return true;
        }
        return false;
    }

    private boolean intercept(HttpServletRequest request) {
        return !request.getMethod().equalsIgnoreCase(HttpMethod.OPTIONS.name()) && !this.isOpen(request.getRequestURI());
    }

    private BaseUserDetails parseClaims(Claims claims) {
        String username = claims.getSubject();
        String userId = claims.getId();
        HashSet<SimpleGrantedAuthority> authorities = new HashSet<SimpleGrantedAuthority>();
        String authorityIdentify = claims.get((Object)"authorities") == null ? "" : claims.get((Object)"authorities").toString();
        for (String authority : StringUtils.split((String)authorityIdentify, (String)",")) {
            authorities.add(new SimpleGrantedAuthority(authority));
        }
        BaseUserDetails userEntity = new BaseUserDetails();
        userEntity.setUsername(username);
        userEntity.setAuthorities(authorities);
        userEntity.setUserId(userId);
        userEntity.setAdmin(Boolean.valueOf(claims.getAudience()));
        return userEntity;
    }

    public void setOpenResources(String[] openResources) {
        this.openResources = openResources;
    }

    public void setAuthenticationValidProvider(AuthenticationValidProvider authenticationValidProvider) {
        this.authenticationValidProvider = authenticationValidProvider;
    }

    public void setAuthenticationValidEnabled(boolean authenticationValidEnabled) {
        this.authenticationValidEnabled = authenticationValidEnabled;
    }
}

