/*
 * Decompiled with CFR 0.152.
 */
package com.aluka.nirvana.framework.security.principal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.userdetails.UserDetails;

public class BaseUserDetails
implements UserDetails {
    public static final String CLIENT_ROLE = "CLIENT";
    private String userId;
    private String username;
    private String password;
    private boolean accountNonExpired;
    private boolean accountNonLocked;
    private boolean enabled;
    private boolean admin;
    private Collection<? extends GrantedAuthority> authorities;
    private Map<String, Object> customFields;

    public Object getCustomField(String name) {
        if (this.customFields == null) {
            return null;
        }
        return this.customFields.get(name);
    }

    public void putCustomField(String name, Object value) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, Object>();
        }
        this.customFields.put(name, value);
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isAccountNonExpired() {
        return this.accountNonExpired;
    }

    public boolean isAccountNonLocked() {
        return this.accountNonLocked;
    }

    public boolean isClient() {
        for (GrantedAuthority grantedAuthority : this.authorities) {
            if (!CLIENT_ROLE.equals(grantedAuthority.toString())) continue;
            return true;
        }
        return false;
    }

    public static BaseUserDetails buildClientUser() {
        BaseUserDetails userDetails = new BaseUserDetails();
        userDetails.setUsername("client");
        userDetails.setPassword("client");
        userDetails.setUserId("client");
        userDetails.setAuthorities(AuthorityUtils.commaSeparatedStringToAuthorityList((String)CLIENT_ROLE));
        return userDetails;
    }

    public boolean isCredentialsNonExpired() {
        return false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getUserId() {
        return this.userId;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setAccountNonExpired(boolean accountNonExpired) {
        this.accountNonExpired = accountNonExpired;
    }

    public void setAccountNonLocked(boolean accountNonLocked) {
        this.accountNonLocked = accountNonLocked;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

    public void setAuthorities(Collection<? extends GrantedAuthority> authorities) {
        this.authorities = authorities;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseUserDetails)) {
            return false;
        }
        BaseUserDetails other = (BaseUserDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        if (this.isAccountNonExpired() != other.isAccountNonExpired()) {
            return false;
        }
        if (this.isAccountNonLocked() != other.isAccountNonLocked()) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isAdmin() != other.isAdmin()) {
            return false;
        }
        Collection<? extends GrantedAuthority> this$authorities = this.getAuthorities();
        Collection<? extends GrantedAuthority> other$authorities = other.getAuthorities();
        if (this$authorities == null ? other$authorities != null : !((Object)this$authorities).equals(other$authorities)) {
            return false;
        }
        Map<String, Object> this$customFields = this.getCustomFields();
        Map<String, Object> other$customFields = other.getCustomFields();
        return !(this$customFields == null ? other$customFields != null : !((Object)this$customFields).equals(other$customFields));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseUserDetails;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        result = result * 59 + (this.isAccountNonExpired() ? 79 : 97);
        result = result * 59 + (this.isAccountNonLocked() ? 79 : 97);
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isAdmin() ? 79 : 97);
        Collection<? extends GrantedAuthority> $authorities = this.getAuthorities();
        result = result * 59 + ($authorities == null ? 43 : ((Object)$authorities).hashCode());
        Map<String, Object> $customFields = this.getCustomFields();
        result = result * 59 + ($customFields == null ? 43 : ((Object)$customFields).hashCode());
        return result;
    }

    public String toString() {
        return "BaseUserDetails(userId=" + this.getUserId() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", accountNonExpired=" + this.isAccountNonExpired() + ", accountNonLocked=" + this.isAccountNonLocked() + ", enabled=" + this.isEnabled() + ", admin=" + this.isAdmin() + ", authorities=" + this.getAuthorities() + ", customFields=" + this.getCustomFields() + ")";
    }
}

