/*
 * Decompiled with CFR 0.152.
 */
package com.aluka.nirvana.framework.security.provider;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

public class DefaultAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger log = LoggerFactory.getLogger(DefaultAuthenticationProvider.class);
    @Autowired(required=false)
    private UserDetailsService userDetailsService;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String username = (String)authentication.getPrincipal();
        String password = (String)authentication.getCredentials();
        log.info("\u767b\u5f55\u8d26\u6237: {}/{}", (Object)username, (Object)password);
        if (this.userDetailsService == null) {
            throw new InternalAuthenticationServiceException("\u8bf7\u521b\u5efa[" + UserDetailsService.class + "]\u7684\u5177\u4f53\u5b9e\u73b0\u7c7b\uff0c\u7528\u4e8e\u83b7\u53d6\u7528\u6237\u4fe1\u606f");
        }
        UserDetails userInfo = this.userDetailsService.loadUserByUsername(username);
        if (!new BCryptPasswordEncoder().matches((CharSequence)password, userInfo.getPassword())) {
            throw new BadCredentialsException("\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
        return new UsernamePasswordAuthenticationToken((Object)userInfo, (Object)password, userInfo.getAuthorities());
    }

    public boolean supports(Class<?> authentication) {
        return true;
    }
}

