/*
 * Decompiled with CFR 0.152.
 */
package com.aluka.nirvana.framework.security.utils;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONObject;
import com.aluka.nirvana.framework.security.principal.BaseUserDetails;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.IOException;
import java.util.Date;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpStatus;

public class JwtUtils {
    public static final String SIGN_USER = "nirvana";
    public static final String AUTHORITIES = "authorities";
    public static final String IS_ADMIN = "authorities";

    public static String create(BaseUserDetails userDetails, Date tokenExpireDate) {
        return Jwts.builder().setId(userDetails.getUserId()).setSubject(userDetails.getUsername()).setIssuedAt(new Date()).setIssuer(SIGN_USER).setAudience(String.valueOf(userDetails.isAdmin())).claim("authorities", (Object)CollectionUtil.join(userDetails.getAuthorities(), (CharSequence)",")).setExpiration(tokenExpireDate).signWith(SignatureAlgorithm.HS512, "nirvanaCommonSecret").compact();
    }

    public static void writeResponse(HttpServletResponse response, HttpStatus status, String message) throws IOException {
        JSONObject responseJson = new JSONObject();
        responseJson.put("status", (Object)status.value());
        responseJson.put("message", (Object)message);
        response.setContentType("application/json;charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        response.getWriter().write(responseJson.toString());
    }

    public static String create(BaseUserDetails userDetails, Date tokenExpireDate, String loginSuccessCustomFields) {
        JwtBuilder jwtBuilder = Jwts.builder().setId(userDetails.getUserId()).setSubject(userDetails.getUsername()).setIssuedAt(new Date()).setIssuer(SIGN_USER).setAudience(String.valueOf(userDetails.isAdmin())).claim("authorities", (Object)CollectionUtil.join(userDetails.getAuthorities(), (CharSequence)",")).setExpiration(tokenExpireDate).signWith(SignatureAlgorithm.HS512, "nirvanaCommonSecret");
        for (String customField : StringUtils.split((String)loginSuccessCustomFields, (String)",")) {
            Object customFieldValue = userDetails.getCustomField(customField);
            if (customFieldValue == null) continue;
            jwtBuilder.claim(customField, customFieldValue);
        }
        return jwtBuilder.compact();
    }
}

