package com.ak.admin.bas.cache;

import cn.hutool.extra.spring.SpringUtil;
import com.ak.admin.bas.dispacher.DPCnt;
import com.ak.core.kt.KtReflect;
import com.ak.event.an.AEventListener;
import org.springframework.stereotype.Component;
import com.ak.redis.service.RedisCache;
import xyz.erupt.jpa.dao.EruptDao;

import javax.persistence.Id;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashMap;

// erupt cache
@Component
public class ECache extends RedisCache {
    public static final long EXPIRE_TIME = 5 * 60;

    @Override
    protected <T> T fromP(Class<T> cls, Object priK) {
        String expr = priName(cls) + " = :priK";
        HashMap<String, Object> params = new HashMap<>();
        params.put("priK", priK);

        T t = SpringUtil.getBean(EruptDao.class).queryEntity(cls, expr, params);
        return t;
    }

    @AEventListener(DPCnt.PERSIST)
    private void onEruptPersist(Object obj, String method) {
        this.del(key(obj));
    }

    public static String key(Object obj) {
        Object priKVal = getPriKVal(obj);
        Class<Serializable> aClass = (Class<Serializable>) obj.getClass();
        return key(aClass, priKVal);
    }

    // get primary key value
    public static <T> Object getPriKVal(T t) {
        Field f = KtReflect.getFieldByAn(t.getClass(), Id.class);
        f.setAccessible(true);

        try {
            return f.get(t);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private String priName(Class cls) {
        Field f = KtReflect.getFieldByAn(cls, Id.class);
        return f.getName();
    }

    @Override
    public long getExpireTime() {
        return EXPIRE_TIME;
    }
}
