package com.ak.admin.bas.dao;

import com.ak.admin.bas.cache.ECache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import com.ak.redis.service.DaoProxy;
import xyz.erupt.jpa.dao.EruptDao;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.Table;
import java.util.List;
import java.util.Map;
import java.util.Optional;

// erupt dao adp
@Component
public class EDaoProxy extends DaoProxy {
    @Autowired
    EruptDao eruptDao;

    @Override
    public <T> void insert(T t) {
        eruptDao.persistAndFlush(t);
    }

    @Override
    public <T> void del(T t) {
        eruptDao.delete(t);
        delCacheT(t);
    }

    @Override
    public <T> T merge(T t) {
        T r = eruptDao.mergeAndFlush(t);
        delCacheT(t);
        return r;
    }

    @Override
    public <T> List<T> list(Class<T> eruptClass) {
        return eruptDao.queryEntityList(eruptClass);
    }

    @Override
    public <T> List<T> list(Class<T> eruptClass, String expr, Map<String, Object> param) {
        return eruptDao.queryEntityList(eruptClass, expr, param);
    }

    @Override
    public <T> T first(Class<T> eruptClass) {
        return eruptDao.queryEntity(eruptClass);
    }

    @Override
    public <T> T first(Class<T> eruptClass, String expr, Map<String, Object> param) {
        List<T> ts = eruptDao.queryEntityList(eruptClass, expr, param);
        if (ts != null && ts.size() > 0) {
            return ts.get(0);
        }

        return null;
    }

    @Override
    public <T> T execute(Class<T> rCls, String sql, Map<String, Object> paramMap) {
        Query query = makeQuery(sql, paramMap, true);
        if (updateOrDel(sql) && rCls.equals(Integer.class)) {
            int ret = query.executeUpdate();
            return (T) (Object) ret;
        }

        if (rCls.equals(List.class)) {
            return (T) query.getResultList();
        }

        return (T) query.getSingleResult();
    }

    private final String UPDATE_SQL = "UPDATE";
    private final String DELETE_SQL = "DELETE";

    private boolean updateOrDel(String sql) {
        return subCompKey(sql, UPDATE_SQL) || subCompKey(sql, DELETE_SQL);
    }

    private boolean subCompKey(String str, String key) {
        if (str.length() >= key.length()) {
            return str.substring(0, key.length()).equals(key);
        }

        return false;
    }

    @Override
    public int executeUpdate(String hql, Map<String, Object> paramMap) {
        Query query = makeQuery(hql, paramMap, false);
        return query.executeUpdate();
    }

    @Override
    public String tableName(Class cls) {
        Table an = (Table) cls.getAnnotation(Table.class);
        if (an != null) {
            return an.name();
        }

        return "";
    }

    // sql or hql
    private Query makeQuery(String shql, Map<String, Object> paramMap, boolean nat) {
        EntityManager entityManager = eruptDao.getEntityManager();
        Query query = nat ? entityManager.createNativeQuery(shql) : entityManager.createQuery(shql);
        Optional.ofNullable(paramMap).ifPresent((map) -> {
            map.forEach(query::setParameter);
        });

        return query;
    }

    private <T> void delCacheT(T t) {
        delCache(ECache.key(t));
    }
}
