package com.ak.admin.bas.dispacher;

import cn.hutool.extra.spring.SpringUtil;
import com.ak.event.EventMgr;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import xyz.erupt.annotation.config.Comment;
import xyz.erupt.annotation.fun.DataProxy;
import xyz.erupt.annotation.query.Condition;

import java.util.List;

@Configuration
@Slf4j
public class CommenDataProxy implements DataProxy<Object> {
    @Bean
    public CommenDataProxy getBean() {
        return new CommenDataProxy();
    }

    private void sendEvent(Object model, String method) {
        // 优先修改缓存，否则精准投放有可能会使用到错误的缓存
        sendEventP(model, method);
        sendEventA(model, method);
    }

    // send event accurate
    private void sendEventA(Object model, String method) {
        String e = model.getClass().getSimpleName() + "@" + method;
        SpringUtil.getBean(EventMgr.class).sendEvent(e, model);
    }

    // send event persist
    private void sendEventP(Object model, String method) {
        Object[] objects = {model, method};
        SpringUtil.getBean(EventMgr.class).sendEvent(DPCnt.PERSIST, objects);
    }

    @Comment("增加前")
    public void beforeAdd(Object model) {
        sendEventA(model, "beforeAdd");
    }

    @Comment("增加后")
    public void afterAdd(Object model) {
        sendEventA(model, "afterAdd");
    }

    @Comment("修改前")
    public void beforeUpdate(Object model) {
        sendEventA(model, "beforeUpdate");
    }

    @Comment("修改后")
    public void afterUpdate(Object model) {
        sendEvent(model, "afterUpdate");
    }

    @Comment("删除前")
    public void beforeDelete(Object model) {
        sendEventA(model, "beforeDelete");
    }

    @Comment("删除后")
    public void afterDelete(Object model) {
        sendEvent(model, "afterDelete");
    }

    @Override
    @Comment("查询前，返回值为：自定义查询条件")
    public String beforeFetch(List<Condition> conditions) {
        for (Condition condition : conditions) {
            if (condition.getValue() instanceof String) {
                condition.setValue(((String) condition.getValue()).replace(" ", ""));
            }
        }
        return null;
    }

    @Override
    @Comment("excel导出，参数需要强转为WorkBook对象")
    public void excelExport(@Comment("POI文档对象") Object workbook) {
        return;
    }
}
