package com.ak.admin.bas.dispacher;

import cn.hutool.core.util.ClassUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import xyz.erupt.annotation.Erupt;
import xyz.erupt.annotation.fun.DataProxy;
import xyz.erupt.core.service.EruptApplication;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.*;

@Component
@Slf4j
public class EruptAutoProxy implements CommandLineRunner {
    @Autowired
    ApplicationContext appContext;

    private final String DATA_PROXY_KEY = "dataProxy";

    @Override
    public void run(String... args) throws Exception {
        try {
            String curPackage = ClassUtil.getPackage(this.getClass());
            String[] scanPackages = EruptApplication.getScanPackage();
            for (String packageName : scanPackages) {
                if (curPackage.length() < packageName.length()) {
                    continue;
                }

                // 不处理非当前项目主包下类（erupt自带节点entity不增加自动代理类）
                if (!curPackage.substring(0, packageName.length()).equals(packageName)) {
                    continue;
                }

                Set<Class<?>> classes = ClassUtil.scanPackage(packageName);
                for (Class aClass : classes) {
                    Erupt an = (Erupt) aClass.getAnnotation(Erupt.class);
                    if (an != null) {
                        InvocationHandler h = Proxy.getInvocationHandler(an);
                        Field hField = h.getClass().getDeclaredField("memberValues");
                        hField.setAccessible(true);
                        Map memberValues = (Map) hField.get(h);

                        Class<? extends DataProxy<?>>[] dataProxiesOrg = (Class<? extends DataProxy<?>>[]) memberValues.get(DATA_PROXY_KEY);
                        if (dataProxiesOrg.length == 0) {
                            Class<? extends DataProxy<?>>[] dataProxies = new Class[]{CommenDataProxy.class};
                            memberValues.put(DATA_PROXY_KEY, dataProxies);
                        }
                    }
                }
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
