/*
 * Decompiled with CFR 0.152.
 */
package cn.flood.jwtp;

import cn.flood.UserToken;
import cn.flood.jwtp.exception.ErrorTokenException;
import cn.flood.jwtp.exception.ExpiredTokenException;
import cn.flood.jwtp.exception.UnauthorizedException;
import cn.flood.jwtp.perm.UrlPerm;
import cn.flood.jwtp.provider.TokenStore;
import cn.flood.jwtp.util.CheckPermissionUtil;
import cn.flood.jwtp.util.TokenUtil;
import io.jsonwebtoken.ExpiredJwtException;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class TokenInterceptor
implements HandlerInterceptor {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private TokenStore tokenStore;
    private UrlPerm urlPerm;
    private static final String options = "OPTIONS";

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String userId;
        if (options.equalsIgnoreCase(request.getMethod().toUpperCase())) {
            CheckPermissionUtil.passOptions(response);
            return false;
        }
        Method method = null;
        if (handler instanceof HandlerMethod) {
            method = ((HandlerMethod)handler).getMethod();
        }
        if (method == null || CheckPermissionUtil.checkIgnore(method)) {
            return true;
        }
        String access_token = CheckPermissionUtil.takeToken(request);
        if (access_token == null || access_token.trim().isEmpty()) {
            throw new ErrorTokenException("Token\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            String tokenKey = this.tokenStore.getTokenKey();
            this.logger.debug("ACCESS_TOKEN: {} , TOKEN_KEY: {}", (Object)access_token, (Object)tokenKey);
            userId = TokenUtil.parseToken(access_token, tokenKey);
        }
        catch (ExpiredJwtException e) {
            this.logger.debug("ERROR: ExpiredJwtException");
            throw new ExpiredTokenException();
        }
        catch (Exception e) {
            throw new ErrorTokenException();
        }
        UserToken userToken = this.tokenStore.findToken(userId, access_token);
        if (userToken == null) {
            this.logger.debug("ERROR: UserToken Not Found");
            throw new ErrorTokenException();
        }
        userToken.setRoles(this.tokenStore.findRolesByUserId(userId, userToken));
        userToken.setPermissions(this.tokenStore.findPermissionsByUserId(userId, userToken));
        if (CheckPermissionUtil.checkToken(method)) {
            request.setAttribute("flood-token", (Object)userToken);
            return true;
        }
        if (CheckPermissionUtil.isNoPermission(userToken, request, response, handler, this.urlPerm)) {
            throw new UnauthorizedException();
        }
        request.setAttribute("flood-token", (Object)userToken);
        return true;
    }

    public TokenInterceptor() {
    }

    public TokenInterceptor(TokenStore tokenStore) {
        this.setTokenStore(tokenStore);
    }

    public TokenInterceptor(TokenStore tokenStore, UrlPerm urlPerm) {
        this.setTokenStore(tokenStore);
        this.setUrlPerm(urlPerm);
    }

    public TokenStore getTokenStore() {
        return this.tokenStore;
    }

    public void setTokenStore(TokenStore tokenStore) {
        this.tokenStore = tokenStore;
    }

    public void setUrlPerm(UrlPerm urlPerm) {
        this.urlPerm = urlPerm;
    }

    public UrlPerm getUrlPerm() {
        return this.urlPerm;
    }
}

