/*
 * Decompiled with CFR 0.152.
 */
package cn.flood.jwtp.client;

import cn.flood.Func;
import cn.flood.UserToken;
import cn.flood.context.SpringContextManager;
import cn.flood.json.JsonUtils;
import cn.flood.jwtp.exception.ErrorTokenException;
import cn.flood.jwtp.exception.ExpiredTokenException;
import cn.flood.jwtp.exception.UnauthorizedException;
import cn.flood.jwtp.perm.UrlPerm;
import cn.flood.jwtp.util.CheckPermissionUtil;
import cn.flood.okhttp.HttpClient;
import cn.flood.okhttp.request.GetRequest;
import cn.flood.rpc.response.Result;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class ClientInterceptor
implements HandlerInterceptor {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private UrlPerm urlPerm;
    private String authCenterUrl;
    private static final String options = "OPTIONS";
    private static final String REDIS_KEY = "flood:oauth_client:";
    private static final long REDIS_TIME = 5L;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (options.equalsIgnoreCase(request.getMethod().toUpperCase())) {
            CheckPermissionUtil.passOptions(response);
            return false;
        }
        Method method = null;
        if (handler instanceof HandlerMethod) {
            method = ((HandlerMethod)handler).getMethod();
        }
        if (method == null || CheckPermissionUtil.checkIgnore(method)) {
            return true;
        }
        String access_token = CheckPermissionUtil.takeToken(request);
        if (access_token == null || access_token.trim().isEmpty()) {
            throw new ErrorTokenException("Token\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.authCenterUrl == null) {
            throw new RuntimeException("\u8bf7\u914d\u7f6eauthCenterUrl");
        }
        UserToken userToken = null;
        StringRedisTemplate stringRedisTemplate = (StringRedisTemplate)SpringContextManager.getBean(StringRedisTemplate.class);
        if (stringRedisTemplate != null) {
            String userTokenStr = (String)stringRedisTemplate.opsForValue().get((Object)(REDIS_KEY + access_token));
            if (Func.isEmpty((Object)userTokenStr)) {
                userToken = this.getRestUrlToken(access_token);
                if (userToken != null) {
                    stringRedisTemplate.opsForValue().set((Object)(REDIS_KEY + access_token), (Object)JsonUtils.toJSONString((Object)userToken), 5L, TimeUnit.MINUTES);
                }
            } else {
                userToken = (UserToken)JsonUtils.toJavaObject((String)userTokenStr, UserToken.class);
            }
        } else {
            userToken = this.getRestUrlToken(access_token);
        }
        if (CheckPermissionUtil.checkToken(method)) {
            request.setAttribute("flood-token", (Object)userToken);
            return true;
        }
        if (CheckPermissionUtil.isNoPermission(userToken, request, response, handler, this.urlPerm)) {
            throw new UnauthorizedException();
        }
        request.setAttribute("flood-token", (Object)userToken);
        return true;
    }

    public UserToken getRestUrlToken(String access_token) throws ExpiredTokenException, ErrorTokenException {
        String url = this.authCenterUrl + "/authentication";
        this.logger.info("========userToken start");
        String result = ((GetRequest)HttpClient.get((String)url).queryString("access_token", access_token)).asString();
        this.logger.info("========userToken end: {}", (Object)result);
        if (result == null) {
            throw new RuntimeException("'" + this.authCenterUrl + "/authentication' return null");
        }
        Result authResult = (Result)JsonUtils.toJavaObject((String)result, Result.class);
        if ("S00000".equals(authResult.get_code())) {
            throw new ExpiredTokenException();
        }
        if (!"000000".equals(authResult.get_code())) {
            throw new ErrorTokenException();
        }
        return (UserToken)authResult.get_data();
    }

    public ClientInterceptor() {
    }

    public ClientInterceptor(UrlPerm urlPerm) {
        this.setUrlPerm(urlPerm);
    }

    public ClientInterceptor(String authCenterUrl, UrlPerm urlPerm) {
        this.setAuthCenterUrl(authCenterUrl);
        this.setUrlPerm(urlPerm);
    }

    public void setUrlPerm(UrlPerm urlPerm) {
        this.urlPerm = urlPerm;
    }

    public UrlPerm getUrlPerm() {
        return this.urlPerm;
    }

    public String getAuthCenterUrl() {
        return this.authCenterUrl;
    }

    public void setAuthCenterUrl(String authCenterUrl) {
        this.authCenterUrl = authCenterUrl;
    }
}

