/*
 * Decompiled with CFR 0.152.
 */
package cn.flood.jwtp.controller;

import cn.flood.UserToken;
import cn.flood.jwtp.annotation.Ignore;
import cn.flood.jwtp.provider.TokenStore;
import cn.flood.jwtp.util.TokenUtil;
import cn.flood.rpc.response.Result;
import cn.flood.rpc.response.ResultWapper;
import io.jsonwebtoken.ExpiredJwtException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Ignore
@RestController
public class AuthCenterController {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private TokenStore tokenStore;

    @RequestMapping(value={"/authentication"})
    public Result authentication(@RequestParam(value="access_token") String access_token) {
        if (access_token == null || access_token.trim().isEmpty()) {
            return ResultWapper.error((String)"access_token Not Found");
        }
        try {
            String tokenKey = this.tokenStore.getTokenKey();
            this.logger.debug("ACCESS_TOKEN: {} ,  TOKEN_KEY: {}", (Object)access_token, (Object)tokenKey);
            String userId = TokenUtil.parseToken(access_token, tokenKey);
            UserToken userToken = this.tokenStore.findToken(userId, access_token);
            if (userToken == null) {
                this.logger.debug("ERROR: UserToken Not Found");
                return ResultWapper.error((String)"UserToken Not Found");
            }
            userToken.setRoles(this.tokenStore.findRolesByUserId(userId, userToken));
            userToken.setPermissions(this.tokenStore.findPermissionsByUserId(userId, userToken));
            return ResultWapper.ok((Object)userToken);
        }
        catch (ExpiredJwtException e) {
            this.logger.debug("ERROR: ExpiredJwtException");
            return ResultWapper.error((String)"ExpiredJwtException");
        }
        catch (Exception e) {
            return ResultWapper.error();
        }
    }
}

