/*
 * Decompiled with CFR 0.152.
 */
package cn.flood.jwtp.perm;

import cn.flood.jwtp.annotation.Logical;
import cn.flood.jwtp.perm.UrlPerm;
import cn.flood.jwtp.perm.UrlPermResult;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.method.HandlerMethod;

public class RestUrlPerm
implements UrlPerm {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public UrlPermResult getPermission(HttpServletRequest request, HttpServletResponse response, HandlerMethod handler) {
        String[] types;
        String[] urls;
        Method method = handler.getMethod();
        ArrayList<String> perms = new ArrayList<String>();
        if (method.getAnnotation(GetMapping.class) != null) {
            urls = method.getAnnotation(GetMapping.class).value();
            types = new String[]{"get"};
        } else if (method.getAnnotation(PostMapping.class) != null) {
            urls = method.getAnnotation(PostMapping.class).value();
            types = new String[]{"post"};
        } else if (method.getAnnotation(PutMapping.class) != null) {
            urls = method.getAnnotation(PutMapping.class).value();
            types = new String[]{"put"};
        } else if (method.getAnnotation(DeleteMapping.class) != null) {
            urls = method.getAnnotation(DeleteMapping.class).value();
            types = new String[]{"delete"};
        } else if (method.getAnnotation(RequestMapping.class) != null) {
            urls = method.getAnnotation(RequestMapping.class).value();
            types = new String[]{"get", "post", "put", "delete"};
        } else {
            urls = new String[]{};
            types = new String[]{};
        }
        Class<?> clazz = method.getDeclaringClass();
        String[] urlPres = clazz.getAnnotation(GetMapping.class) != null ? clazz.getAnnotation(GetMapping.class).value() : (clazz.getAnnotation(PostMapping.class) != null ? clazz.getAnnotation(PostMapping.class).value() : (clazz.getAnnotation(PutMapping.class) != null ? clazz.getAnnotation(PutMapping.class).value() : (clazz.getAnnotation(DeleteMapping.class) != null ? clazz.getAnnotation(DeleteMapping.class).value() : (clazz.getAnnotation(RequestMapping.class) != null ? clazz.getAnnotation(RequestMapping.class).value() : new String[]{}))));
        for (String type : types) {
            for (String url : urls) {
                StringBuilder sb = new StringBuilder();
                sb.append(type);
                sb.append(":");
                if (urlPres != null && urlPres.length > 0) {
                    if (!urlPres[0].startsWith("/")) {
                        sb.append("/");
                    }
                    sb.append(urlPres[0]);
                }
                if (!url.startsWith("/")) {
                    sb.append("/");
                }
                sb.append(url);
                perms.add(sb.toString());
            }
        }
        Object[] arrays = perms.toArray(new String[perms.size()]);
        this.logger.debug("Generate Permissions: " + Arrays.toString(arrays));
        return new UrlPermResult((String[])arrays, Logical.OR);
    }

    @Override
    public UrlPermResult getRoles(HttpServletRequest request, HttpServletResponse response, HandlerMethod handler) {
        return new UrlPermResult(new String[0], Logical.OR);
    }
}

