/*
 * Decompiled with CFR 0.152.
 */
package cn.flood.jwtp.provider;

import cn.flood.UserToken;
import cn.flood.json.JsonUtils;
import cn.flood.jwtp.provider.TokenStoreAbstract;
import cn.flood.jwtp.util.TokenUtil;
import cn.flood.lang.StringUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.Assert;

public class JdbcTokenStore
extends TokenStoreAbstract {
    private final JdbcTemplate jdbcTemplate;
    private RowMapper<UserToken> rowMapper = new TokenRowMapper();
    private static final String UPDATE_FIELDS = "user_id, access_token, refresh_token, expire_time, refresh_token_expire_time, roles, permissions, info";
    private static final String BASE_SELECT = "select token_id, user_id, access_token, refresh_token, expire_time, refresh_token_expire_time, roles, permissions, info from oauth_token";
    private static final String SQL_SELECT_BY_TOKEN = "select token_id, user_id, access_token, refresh_token, expire_time, refresh_token_expire_time, roles, permissions, info from oauth_token where user_id = ? and access_token = ?";
    private static final String SQL_SELECT_BY_USER_ID = "select token_id, user_id, access_token, refresh_token, expire_time, refresh_token_expire_time, roles, permissions, info from oauth_token where user_id = ? order by create_time";
    private static final String SQL_INSERT = "insert into oauth_token (user_id, access_token, refresh_token, expire_time, refresh_token_expire_time, roles, permissions, info) values (?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String SQL_DELETE = "delete from oauth_token where user_id = ? and access_token = ?";
    private static final String SQL_DELETE_BY_USER_ID = "delete from oauth_token where user_id = ?";
    private static final String SQL_UPDATE_ROLES = "update oauth_token set roles = ? where user_id = ?";
    private static final String SQL_UPDATE_PERMS = "update oauth_token set permissions = ? where user_id = ?";
    private static final String SQL_UPDATE_INFO = "update oauth_token set info = ? where user_id = ?";
    private static final String SQL_SELECT_REFRESH_TOKEN = "select token_id, user_id, access_token, refresh_token, expire_time, refresh_token_expire_time, roles, permissions, info from oauth_token where user_id = ? and refresh_token= ?";
    private static final String SQL_SELECT_KEY = "select token_key from oauth_token_key";
    private static final String SQL_INSERT_KEY = "insert into oauth_token_key (token_key) values (?)";

    public JdbcTokenStore(DataSource dataSource) {
        Assert.notNull((Object)dataSource, (String)"DataSource required");
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    @Override
    public String getTokenKey() {
        if (mTokenKey == null) {
            try {
                mTokenKey = (String)this.jdbcTemplate.queryForObject(SQL_SELECT_KEY, String.class);
            }
            catch (EmptyResultDataAccessException emptyResultDataAccessException) {
                // empty catch block
            }
            if (mTokenKey == null || mTokenKey.trim().isEmpty()) {
                mTokenKey = TokenUtil.getHexKey();
                this.jdbcTemplate.update(SQL_INSERT_KEY, new Object[]{mTokenKey});
            }
        }
        return mTokenKey;
    }

    @Override
    public int storeToken(UserToken userToken) {
        List<UserToken> userUserTokens;
        List<Object> objects = this.getFieldsForUpdate(userToken);
        int rs = this.jdbcTemplate.update(SQL_INSERT, StringUtils.objectListToArray(objects));
        if (this.getMaxToken() != -1 && (userUserTokens = this.findTokensByUserId(userToken.getUserId())).size() > this.getMaxToken()) {
            for (int i = 0; i < userUserTokens.size() - this.getMaxToken(); ++i) {
                this.removeToken(userToken.getUserId(), userUserTokens.get(i).getAccessToken());
            }
        }
        return rs;
    }

    @Override
    public UserToken findToken(String userId, String access_token) {
        try {
            return (UserToken)this.jdbcTemplate.queryForObject(SQL_SELECT_BY_TOKEN, this.rowMapper, new Object[]{userId, access_token});
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            return null;
        }
    }

    @Override
    public List<UserToken> findTokensByUserId(String userId) {
        try {
            return this.jdbcTemplate.query(SQL_SELECT_BY_USER_ID, this.rowMapper, new Object[]{userId});
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            return null;
        }
    }

    @Override
    public UserToken findRefreshToken(String userId, String refresh_token) {
        try {
            List list = this.jdbcTemplate.query(SQL_SELECT_REFRESH_TOKEN, this.rowMapper, new Object[]{userId, refresh_token});
            if (list.size() > 0) {
                return (UserToken)list.get(0);
            }
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public int removeToken(String userId, String access_token) {
        return this.jdbcTemplate.update(SQL_DELETE, new Object[]{userId, access_token});
    }

    @Override
    public int removeTokensByUserId(String userId) {
        return this.jdbcTemplate.update(SQL_DELETE_BY_USER_ID, new Object[]{userId});
    }

    @Override
    public int updateRolesByUserId(String userId, String[] roles) {
        String rolesJson = JsonUtils.toJSONString((Object)roles);
        return this.jdbcTemplate.update(SQL_UPDATE_ROLES, new Object[]{rolesJson, userId});
    }

    @Override
    public int updatePermissionsByUserId(String userId, String[] permissions) {
        String permJson = JsonUtils.toJSONString((Object)permissions);
        return this.jdbcTemplate.update(SQL_UPDATE_PERMS, new Object[]{permJson, userId});
    }

    @Override
    public int updateUserInfoByUserId(String userId, String userInfo) {
        return this.jdbcTemplate.update(SQL_UPDATE_INFO, new Object[]{userInfo, userId});
    }

    @Override
    public String[] findRolesByUserId(String userId, UserToken userToken) {
        if (this.getFindRolesSql() == null || this.getFindRolesSql().trim().isEmpty()) {
            return userToken.getRoles();
        }
        try {
            List roleList = this.jdbcTemplate.query(this.getFindRolesSql(), (RowMapper)new RowMapper<String>(){

                public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                    return rs.getString(1);
                }
            }, new Object[]{userId});
            return StringUtils.stringListToArray((List)roleList);
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            return null;
        }
    }

    @Override
    public String[] findPermissionsByUserId(String userId, UserToken userToken) {
        if (this.getFindPermissionsSql() == null || this.getFindPermissionsSql().trim().isEmpty()) {
            return userToken.getPermissions();
        }
        try {
            List permList = this.jdbcTemplate.query(this.getFindPermissionsSql(), (RowMapper)new RowMapper<String>(){

                public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                    return rs.getString(1);
                }
            }, new Object[]{userId});
            return StringUtils.stringListToArray((List)permList);
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            return null;
        }
    }

    private List<Object> getFieldsForUpdate(UserToken userToken) {
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add(userToken.getUserId());
        objects.add(userToken.getAccessToken());
        objects.add(userToken.getRefreshToken());
        objects.add(userToken.getExpireTime());
        objects.add(userToken.getRefreshTokenExpireTime());
        objects.add(JsonUtils.toJSONString((Object)userToken.getRoles()));
        objects.add(JsonUtils.toJSONString((Object)userToken.getPermissions()));
        objects.add(userToken.getUserInfo());
        return objects;
    }

    private static class TokenRowMapper
    implements RowMapper<UserToken> {
        private TokenRowMapper() {
        }

        public UserToken mapRow(ResultSet rs, int rowNum) throws SQLException {
            int token_id = rs.getInt("token_id");
            String user_id = rs.getString("user_id");
            String access_token = rs.getString("access_token");
            String refresh_token = rs.getString("refresh_token");
            Date expire_time = this.timestampToDate(rs.getTimestamp("expire_time"));
            Date refresh_token_expire_time = this.timestampToDate(rs.getTimestamp("refresh_token_expire_time"));
            String roles = rs.getString("roles");
            String permissions = rs.getString("permissions");
            String info = rs.getString("info");
            UserToken userToken = new UserToken();
            userToken.setTokenId(Integer.valueOf(token_id));
            userToken.setUserId(user_id);
            userToken.setAccessToken(access_token);
            userToken.setRefreshToken(refresh_token);
            userToken.setExpireTime(expire_time);
            userToken.setUserInfo(info);
            userToken.setRefreshTokenExpireTime(refresh_token_expire_time);
            userToken.setRoles(StringUtils.stringListToArray((List)JsonUtils.toJavaObjectList((String)roles, String.class)));
            userToken.setPermissions(StringUtils.stringListToArray((List)JsonUtils.toJavaObjectList((String)permissions, String.class)));
            return userToken;
        }

        private Date timestampToDate(Timestamp timestamp) {
            if (timestamp != null) {
                return new Date(timestamp.getTime());
            }
            return null;
        }
    }
}

