/*
 * Decompiled with CFR 0.152.
 */
package cn.flood.jwtp.provider;

import cn.flood.Func;
import cn.flood.UserToken;
import cn.flood.jwtp.provider.TokenStoreAbstract;
import cn.flood.jwtp.util.TokenUtil;
import cn.flood.lang.StringUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.Assert;

public class RedisTokenStore
extends TokenStoreAbstract {
    private static final String KEY_TOKEN_KEY = "oauth_token_key";
    private static final String KEY_PRE_TOKEN = "flood:oauth_token:";
    private static final String KEY_PRE_REFRESH_TOKEN = "flood:oauth_refresh_token:";
    private static final String KEY_PRE_ROLE = "flood:oauth_role:";
    private static final String KEY_PRE_PERM = "flood:oauth_prem:";
    private static final String KEY_PRE_INFO = "flood:oauth_info:";
    private final StringRedisTemplate redisTemplate;
    private final Object jdbcTemplate;

    public RedisTokenStore(StringRedisTemplate redisTemplate) {
        this(redisTemplate, null);
    }

    public RedisTokenStore(StringRedisTemplate redisTemplate, DataSource dataSource) {
        Assert.notNull((Object)redisTemplate, (String)"StringRedisTemplate required");
        this.redisTemplate = redisTemplate;
        this.jdbcTemplate = dataSource != null ? new JdbcTemplate(dataSource) : null;
    }

    @Override
    public String getTokenKey() {
        if (mTokenKey == null && ((mTokenKey = (String)this.redisTemplate.opsForValue().get((Object)KEY_TOKEN_KEY)) == null || mTokenKey.trim().isEmpty())) {
            mTokenKey = TokenUtil.getHexKey();
            this.redisTemplate.opsForValue().set((Object)KEY_TOKEN_KEY, (Object)mTokenKey);
        }
        return mTokenKey;
    }

    @Override
    public int storeToken(UserToken userToken) {
        this.redisTemplate.opsForList().rightPush((Object)(KEY_PRE_TOKEN + userToken.getUserId()), (Object)userToken.getAccessToken());
        if (userToken.getRefreshToken() != null && this.findRefreshToken(userToken.getUserId(), userToken.getRefreshToken()) == null) {
            this.redisTemplate.opsForList().rightPush((Object)(KEY_PRE_REFRESH_TOKEN + userToken.getUserId()), (Object)userToken.getRefreshToken());
        }
        this.updateRolesByUserId(userToken.getUserId(), userToken.getRoles());
        this.updatePermissionsByUserId(userToken.getUserId(), userToken.getPermissions());
        this.updateUserInfoByUserId(userToken.getUserId(), userToken.getUserInfo());
        if (this.getMaxToken() != -1) {
            this.listMaxLimit(KEY_PRE_TOKEN + userToken.getUserId(), this.getMaxToken());
            this.listMaxLimit(KEY_PRE_REFRESH_TOKEN + userToken.getUserId(), this.getMaxToken());
        }
        return 1;
    }

    @Override
    public UserToken findToken(String userId, String access_token) {
        List<UserToken> userTokens = this.findTokensByUserId(userId);
        if (userTokens != null && access_token != null) {
            for (UserToken userToken : userTokens) {
                if (!access_token.equals(userToken.getAccessToken())) continue;
                return userToken;
            }
        }
        return null;
    }

    @Override
    public List<UserToken> findTokensByUserId(String userId) {
        if (userId == null || userId.trim().isEmpty()) {
            return null;
        }
        ArrayList<UserToken> userTokens = new ArrayList<UserToken>();
        List accessTokens = this.redisTemplate.opsForList().range((Object)(KEY_PRE_TOKEN + userId), 0L, -1L);
        if (accessTokens != null && accessTokens.size() > 0) {
            for (String accessToken : accessTokens) {
                UserToken userToken = new UserToken();
                userToken.setUserId(userId);
                userToken.setAccessToken(accessToken);
                userToken.setPermissions(StringUtils.stringSetToArray((Set)this.redisTemplate.opsForSet().members((Object)(KEY_PRE_PERM + userId))));
                userToken.setRoles(StringUtils.stringSetToArray((Set)this.redisTemplate.opsForSet().members((Object)(KEY_PRE_ROLE + userId))));
                String info = (String)this.redisTemplate.opsForValue().get((Object)(KEY_PRE_INFO + userId));
                if (Func.isNotEmpty((Object)info)) {
                    userToken.setUserInfo(info);
                }
                userTokens.add(userToken);
            }
        }
        return userTokens;
    }

    @Override
    public UserToken findRefreshToken(String userId, String refresh_token) {
        if (userId != null && !userId.trim().isEmpty() && refresh_token != null) {
            List refreshTokens = this.redisTemplate.opsForList().range((Object)(KEY_PRE_REFRESH_TOKEN + userId), 0L, -1L);
            for (String refreshToken : refreshTokens) {
                if (!refresh_token.equals(refreshToken)) continue;
                UserToken userToken = new UserToken();
                userToken.setUserId(userId);
                userToken.setRefreshToken(refresh_token);
                return userToken;
            }
        }
        return null;
    }

    @Override
    public int removeToken(String userId, String access_token) {
        this.redisTemplate.opsForList().remove((Object)(KEY_PRE_TOKEN + userId), 0L, (Object)access_token);
        return 1;
    }

    @Override
    public int removeTokensByUserId(String userId) {
        this.redisTemplate.delete((Object)(KEY_PRE_TOKEN + userId));
        this.redisTemplate.delete((Object)(KEY_PRE_ROLE + userId));
        this.redisTemplate.delete((Object)(KEY_PRE_PERM + userId));
        this.redisTemplate.delete((Object)(KEY_PRE_INFO + userId));
        this.redisTemplate.delete((Object)(KEY_PRE_REFRESH_TOKEN + userId));
        return 1;
    }

    @Override
    public int updateRolesByUserId(String userId, String[] roles) {
        String roleKey = KEY_PRE_ROLE + userId;
        this.redisTemplate.delete((Object)roleKey);
        if (roles != null && roles.length > 0) {
            this.redisTemplate.opsForSet().add((Object)roleKey, (Object[])roles);
        }
        return 1;
    }

    @Override
    public int updatePermissionsByUserId(String userId, String[] permissions) {
        String permKey = KEY_PRE_PERM + userId;
        this.redisTemplate.delete((Object)permKey);
        if (permissions != null && permissions.length > 0) {
            this.redisTemplate.opsForSet().add((Object)permKey, (Object[])permissions);
        }
        return 1;
    }

    @Override
    public int updateUserInfoByUserId(String userId, String userInfo) {
        String infoKey = KEY_PRE_INFO + userId;
        this.redisTemplate.delete((Object)infoKey);
        if (!Func.isEmpty((Object)userInfo)) {
            this.redisTemplate.opsForValue().set((Object)infoKey, (Object)userInfo);
        }
        return 1;
    }

    @Override
    public String[] findRolesByUserId(String userId, UserToken userToken) {
        if (this.getFindRolesSql() == null || this.getFindRolesSql().trim().isEmpty()) {
            return userToken.getRoles();
        }
        if (this.jdbcTemplate != null) {
            try {
                List roleList = ((JdbcTemplate)this.jdbcTemplate).query(this.getFindRolesSql(), (RowMapper)new RowMapper<String>(){

                    public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                        return rs.getString(1);
                    }
                }, new Object[]{userId});
                return StringUtils.stringListToArray((List)roleList);
            }
            catch (EmptyResultDataAccessException emptyResultDataAccessException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String[] findPermissionsByUserId(String userId, UserToken userToken) {
        if (this.getFindPermissionsSql() == null || this.getFindPermissionsSql().trim().isEmpty()) {
            return userToken.getPermissions();
        }
        if (this.jdbcTemplate != null) {
            try {
                List permList = ((JdbcTemplate)this.jdbcTemplate).query(this.getFindPermissionsSql(), (RowMapper)new RowMapper<String>(){

                    public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                        return rs.getString(1);
                    }
                }, new Object[]{userId});
                return StringUtils.stringListToArray((List)permList);
            }
            catch (EmptyResultDataAccessException emptyResultDataAccessException) {
                // empty catch block
            }
        }
        return null;
    }

    private void listMaxLimit(String key, int max) {
        Long userTokenSize = this.redisTemplate.opsForList().size((Object)key);
        if (userTokenSize > (long)max) {
            int i = 0;
            while ((long)i < userTokenSize - (long)max) {
                this.redisTemplate.opsForList().leftPop((Object)key);
                ++i;
            }
        }
    }
}

