/*
 * Decompiled with CFR 0.152.
 */
package cn.flood.jwtp.provider;

import cn.flood.Func;
import cn.flood.UserToken;
import cn.flood.exception.CoreException;
import cn.flood.jwtp.exception.ErrorTokenException;
import cn.flood.jwtp.exception.ExpiredTokenException;
import cn.flood.jwtp.provider.TokenStore;
import cn.flood.jwtp.util.TokenUtil;
import io.jsonwebtoken.ExpiredJwtException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TokenStoreAbstract
implements TokenStore {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Integer maxToken = -1;
    private String findRolesSql;
    private String findPermissionsSql;
    public static String mTokenKey;

    @Override
    public UserToken createNewToken(String userId) {
        return this.createNewToken(userId, null, null, null);
    }

    @Override
    public UserToken createNewToken(String userId, String userInfo) {
        return this.createNewToken(userId, userInfo, null, null);
    }

    @Override
    public UserToken createNewToken(String userId, String userInfo, long expire) {
        return this.createNewToken(userId, userInfo, null, null, expire);
    }

    @Override
    public UserToken createNewToken(String userId, String userInfo, long expire, long rtExpire) {
        return this.createNewToken(userId, userInfo, null, null, expire, rtExpire);
    }

    @Override
    public UserToken createNewToken(String userId, String userInfo, String[] permissions, String[] roles) {
        return this.createNewToken(userId, userInfo, permissions, roles, 7200L);
    }

    @Override
    public UserToken createNewToken(String userId, String userInfo, String[] permissions, String[] roles, long expire) {
        return this.createNewToken(userId, userInfo, permissions, roles, expire, 7776000L);
    }

    @Override
    public UserToken createNewToken(String userId, String userInfo, String[] permissions, String[] roles, long expire, long rtExpire) {
        String tokenKey = this.getTokenKey();
        this.logger.debug("TOKEN_KEY: " + tokenKey);
        UserToken userToken = TokenUtil.buildToken(userId, expire, rtExpire, TokenUtil.parseHexKey(tokenKey));
        userToken.setRoles(roles);
        userToken.setPermissions(permissions);
        if (!Func.isEmpty((Object)userInfo)) {
            userToken.setUserInfo(userInfo);
        }
        if (this.storeToken(userToken) > 0) {
            return userToken;
        }
        return null;
    }

    @Override
    public UserToken refreshToken(String refresh_token) throws CoreException {
        return this.refreshToken(refresh_token, null, 7200L);
    }

    @Override
    public UserToken refreshToken(String refresh_token, String userInfo) throws CoreException {
        return this.refreshToken(refresh_token, userInfo, 7200L);
    }

    @Override
    public UserToken refreshToken(String refresh_token, String userInfo, long expire) throws CoreException {
        return this.refreshToken(refresh_token, userInfo, null, null, expire);
    }

    @Override
    public UserToken refreshToken(String refresh_token, String userInfo, String[] permissions, String[] roles, long expire) throws CoreException {
        String userId;
        String tokenKey = this.getTokenKey();
        this.logger.debug("TOKEN_KEY: " + tokenKey);
        try {
            userId = TokenUtil.parseToken(refresh_token, tokenKey);
        }
        catch (ExpiredJwtException e) {
            throw new ExpiredTokenException();
        }
        catch (Exception e) {
            throw new ErrorTokenException();
        }
        if (userId != null) {
            UserToken refreshUserToken = this.findRefreshToken(userId, refresh_token);
            if (refreshUserToken == null) {
                throw new ErrorTokenException();
            }
            UserToken userToken = TokenUtil.buildToken(userId, expire, null, TokenUtil.parseHexKey(tokenKey), false);
            userToken.setRoles(roles);
            if (Func.isEmpty((Object)userInfo)) {
                userToken.setUserInfo(userInfo);
            }
            userToken.setPermissions(permissions);
            userToken.setRefreshToken(refresh_token);
            userToken.setRefreshTokenExpireTime(refreshUserToken.getRefreshTokenExpireTime());
            if (this.storeToken(userToken) > 0) {
                return userToken;
            }
        }
        return null;
    }

    @Override
    public void setMaxToken(Integer maxToken) {
        this.maxToken = maxToken;
    }

    @Override
    public void setFindRolesSql(String findRolesSql) {
        this.findRolesSql = findRolesSql;
    }

    @Override
    public void setFindPermissionsSql(String findPermissionsSql) {
        this.findPermissionsSql = findPermissionsSql;
    }

    @Override
    public Integer getMaxToken() {
        return this.maxToken;
    }

    @Override
    public String getFindRolesSql() {
        return this.findRolesSql;
    }

    @Override
    public String getFindPermissionsSql() {
        return this.findPermissionsSql;
    }
}

