/*
 * Decompiled with CFR 0.152.
 */
package cn.flood.jwtp.util;

import cn.flood.Func;
import cn.flood.UserToken;
import cn.flood.json.JsonUtils;
import cn.flood.jwtp.annotation.Ignore;
import cn.flood.jwtp.annotation.Logical;
import cn.flood.jwtp.annotation.RequiresPermissions;
import cn.flood.jwtp.annotation.RequiresRoles;
import cn.flood.jwtp.annotation.RequiresToken;
import cn.flood.jwtp.perm.UrlPerm;
import cn.flood.jwtp.perm.UrlPermResult;
import cn.flood.jwtp.requestWrapper.RequestWrapper;
import cn.flood.jwtp.util.SecureUtil;
import java.lang.reflect.Method;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.method.HandlerMethod;

public class CheckPermissionUtil {
    public static boolean checkIgnore(Method method) {
        Ignore annotation = method.getAnnotation(Ignore.class);
        return annotation != null || (annotation = method.getDeclaringClass().getAnnotation(Ignore.class)) != null;
    }

    public static boolean checkToken(Method method) {
        RequiresToken annotation = method.getAnnotation(RequiresToken.class);
        return annotation != null || (annotation = method.getDeclaringClass().getAnnotation(RequiresToken.class)) != null;
    }

    public static boolean checkPermission(UserToken userToken, HttpServletRequest request, HttpServletResponse response, Object handler, UrlPerm urlPerm) {
        Logical logical;
        String[] requiresPermissions;
        Method method = ((HandlerMethod)handler).getMethod();
        RequiresPermissions annotation = method.getAnnotation(RequiresPermissions.class);
        if (annotation == null) {
            annotation = method.getDeclaringClass().getAnnotation(RequiresPermissions.class);
        }
        if (annotation != null) {
            requiresPermissions = annotation.value();
            logical = annotation.logical();
        } else if (urlPerm != null) {
            UrlPermResult upr = urlPerm.getPermission(request, response, (HandlerMethod)handler);
            requiresPermissions = upr.getValues();
            logical = upr.getLogical();
        } else {
            return true;
        }
        return SecureUtil.hasPermission(userToken, requiresPermissions, logical);
    }

    public static boolean checkRole(UserToken userToken, HttpServletRequest request, HttpServletResponse response, Object handler, UrlPerm urlPerm) {
        Logical logical;
        String[] requiresRoles;
        Method method = ((HandlerMethod)handler).getMethod();
        RequiresRoles annotation = method.getAnnotation(RequiresRoles.class);
        if (annotation == null) {
            annotation = method.getDeclaringClass().getAnnotation(RequiresRoles.class);
        }
        if (annotation != null) {
            requiresRoles = annotation.value();
            logical = annotation.logical();
        } else if (urlPerm != null) {
            UrlPermResult upr = urlPerm.getRoles(request, response, (HandlerMethod)handler);
            requiresRoles = upr.getValues();
            logical = upr.getLogical();
        } else {
            return true;
        }
        return SecureUtil.hasRole(userToken, requiresRoles, logical);
    }

    public static boolean isNoPermission(UserToken userToken, HttpServletRequest request, HttpServletResponse response, Object handler, UrlPerm urlPerm) {
        return !CheckPermissionUtil.checkPermission(userToken, request, response, handler, urlPerm) || !CheckPermissionUtil.checkRole(userToken, request, response, handler, urlPerm);
    }

    public static void passOptions(HttpServletResponse response) {
        response.setStatus(200);
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Access-Control-Allow-Methods", "GET, POST, PUT, DELETE, OPTIONS");
        response.setHeader("Access-Control-Max-Age", "3600");
        response.setHeader("Access-Control-Allow-Headers", "Content-Type, x-requested-with, X-Custom-Header, Authorization");
    }

    public static String takeToken(HttpServletRequest request) {
        String access_token = request.getHeader("Authorization");
        if (access_token != null && access_token.length() >= 7) {
            access_token = access_token.substring(7);
        } else {
            String payload;
            access_token = request.getParameter("access_token");
            if ((access_token == null || access_token.trim().isEmpty()) && !Func.isEmpty((Object)(payload = new RequestWrapper(request).getBodyString((ServletRequest)request)))) {
                Map map = JsonUtils.toMap((String)payload);
                access_token = (String)map.get("access_token");
            }
        }
        return access_token;
    }
}

