/*
 * Decompiled with CFR 0.152.
 */
package cn.flood.jwtp.util;

import cn.flood.UserToken;
import cn.flood.jwtp.annotation.Logical;
import cn.flood.jwtp.provider.TokenStore;
import cn.flood.jwtp.util.CheckPermissionUtil;
import cn.flood.jwtp.util.TokenUtil;
import io.jsonwebtoken.ExpiredJwtException;
import java.util.Collection;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SecureUtil {
    public static boolean hasRole(UserToken userToken, String[] roles, Logical logical) {
        if (userToken == null) {
            return false;
        }
        if (roles == null || roles.length <= 0) {
            return true;
        }
        boolean rs = false;
        for (int i = 0; i < roles.length; ++i) {
            if (userToken.getRoles() != null) {
                rs = SecureUtil.contains(userToken.getRoles(), roles[i]);
            }
            if (logical == (rs ? Logical.OR : Logical.AND)) break;
        }
        return rs;
    }

    public static boolean hasRole(UserToken userToken, String roles) {
        return SecureUtil.hasRole(userToken, new String[]{roles}, Logical.OR);
    }

    public static boolean hasRole(HttpServletRequest request, String[] roles, Logical logical) {
        return SecureUtil.hasRole(SecureUtil.getToken(request), roles, logical);
    }

    public static boolean hasRole(HttpServletRequest request, String roles) {
        return SecureUtil.hasRole(SecureUtil.getToken(request), new String[]{roles}, Logical.OR);
    }

    public static boolean hasPermission(UserToken userToken, String[] permissions, Logical logical) {
        if (userToken == null) {
            return false;
        }
        if (permissions == null || permissions.length <= 0) {
            return true;
        }
        boolean rs = false;
        for (int i = 0; i < permissions.length; ++i) {
            if (userToken.getPermissions() != null) {
                rs = SecureUtil.contains(userToken.getPermissions(), permissions[i]);
            }
            if (logical == (rs ? Logical.OR : Logical.AND)) break;
        }
        return rs;
    }

    public static boolean hasPermission(UserToken userToken, String permissions) {
        return SecureUtil.hasPermission(userToken, new String[]{permissions}, Logical.OR);
    }

    public static boolean hasPermission(HttpServletRequest request, String[] permissions, Logical logical) {
        return SecureUtil.hasPermission(SecureUtil.getToken(request), permissions, logical);
    }

    public static boolean hasPermission(HttpServletRequest request, String permissions) {
        return SecureUtil.hasPermission(SecureUtil.getToken(request), new String[]{permissions}, Logical.OR);
    }

    public static UserToken getToken(HttpServletRequest request) {
        Object token = request.getAttribute("flood-token");
        return token == null ? null : (UserToken)token;
    }

    public static UserToken parseToken(HttpServletRequest request) {
        return SecureUtil.parseToken(request, SecureUtil.getBean(TokenStore.class));
    }

    public static UserToken parseToken(HttpServletRequest request, TokenStore tokenStore) {
        String access_token;
        UserToken userToken = SecureUtil.getToken(request);
        if (userToken == null && tokenStore != null && (access_token = CheckPermissionUtil.takeToken(request)) != null && !access_token.trim().isEmpty()) {
            try {
                String tokenKey = tokenStore.getTokenKey();
                String userId = TokenUtil.parseToken(access_token, tokenKey);
                userToken = tokenStore.findToken(userId, access_token);
                if (userToken != null) {
                    userToken.setRoles(tokenStore.findRolesByUserId(userId, userToken));
                    userToken.setPermissions(tokenStore.findPermissionsByUserId(userId, userToken));
                }
            }
            catch (ExpiredJwtException e) {
                System.out.println("token\u5df2\u8fc7\u671f");
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        return userToken;
    }

    private static boolean contains(String[] strs, String str) {
        for (int i = 0; i < strs.length; ++i) {
            if (!strs[i].equals(str)) continue;
            return true;
        }
        return false;
    }

    public static <T> T getBean(Class<T> clazz) {
        T bean = null;
        try {
            ServletContext servletContext = ContextLoader.getCurrentWebApplicationContext().getServletContext();
            WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
            Collection beans = applicationContext.getBeansOfType(clazz).values();
            while (beans.iterator().hasNext() && (bean = (T)beans.iterator().next()) == null) {
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bean;
    }
}

