/*
 * Decompiled with CFR 0.152.
 */
package cn.flood.jwtp.util;

import cn.flood.UserToken;
import cn.flood.jwtp.util.Hex;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.security.Keys;
import java.security.Key;
import java.util.Date;
import javax.crypto.SecretKey;

public class TokenUtil {
    public static final long DEFAULT_EXPIRE = 7200L;
    public static final long DEFAULT_EXPIRE_REFRESH_TOKEN = 7776000L;

    public static UserToken buildToken(String subject) {
        return TokenUtil.buildToken(subject, 7200L);
    }

    public static UserToken buildToken(String subject, long expire) {
        return TokenUtil.buildToken(subject, expire, 7776000L);
    }

    public static UserToken buildToken(String subject, long expire, long rtExpire) {
        return TokenUtil.buildToken(subject, expire, rtExpire, TokenUtil.getKey());
    }

    public static UserToken buildToken(String subject, Long expire, Long rtExpire, Key key) {
        return TokenUtil.buildToken(subject, expire, rtExpire, key, true);
    }

    public static UserToken buildToken(String subject, Long expire, Long rtExpire, Key key, boolean needRt) {
        Date expireDate = new Date(new Date().getTime() + 1000L * expire);
        String access_token = Jwts.builder().setSubject(subject).signWith(key).setExpiration(expireDate).compact();
        UserToken userToken = new UserToken();
        userToken.setUserId(subject);
        userToken.setAccessToken(access_token);
        userToken.setExpireTime(expireDate);
        if (needRt) {
            Date refreshExpireDate = new Date(new Date().getTime() + 1000L * rtExpire);
            String refresh_token = Jwts.builder().setSubject(subject).signWith(key).setExpiration(refreshExpireDate).compact();
            userToken.setRefreshToken(refresh_token);
            userToken.setRefreshTokenExpireTime(refreshExpireDate);
        }
        return userToken;
    }

    public static String parseToken(String token, String hexKey) {
        Jws claimsJws = Jwts.parser().setSigningKey(TokenUtil.parseHexKey(hexKey)).parseClaimsJws(token);
        return ((Claims)claimsJws.getBody()).getSubject();
    }

    public static Key getKey() {
        return Keys.secretKeyFor((SignatureAlgorithm)SignatureAlgorithm.HS256);
    }

    public static String getHexKey() {
        return TokenUtil.getHexKey(TokenUtil.getKey());
    }

    public static String getHexKey(Key key) {
        return Hex.encodeToString(key.getEncoded());
    }

    public static Key parseHexKey(String hexKey) {
        if (hexKey == null || hexKey.trim().isEmpty()) {
            return null;
        }
        SecretKey key = Keys.hmacShaKeyFor((byte[])Hex.decode(hexKey));
        return key;
    }
}

