/*
 * Decompiled with CFR 0.152.
 */
package cn.flood.async;

import cn.flood.async.AsyncProperties;
import cn.flood.async.AsyncUncaughtExceptionHandlerEx;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

@Configuration
@EnableAsync
@AutoConfigureAfter(value={AsyncProperties.class})
@EnableConfigurationProperties(value={AsyncProperties.class})
public class AsyncExecutorConfiguration
implements AsyncConfigurer,
SchedulingConfigurer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private AsyncProperties asyncProperties;

    @Bean
    public Executor customAsync() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(this.asyncProperties.getCorePoolSize());
        executor.setMaxPoolSize(this.asyncProperties.getMaxPoolSize());
        executor.setQueueCapacity(this.asyncProperties.getQueueCapacity());
        executor.setThreadNamePrefix("flood-async-executor-");
        executor.setKeepAliveSeconds(this.asyncProperties.getKeepAliveSeconds());
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        executor.initialize();
        return executor;
    }

    public Executor getAsyncExecutor() {
        this.logger.debug("Creating Async Task Executor");
        return this.customAsync();
    }

    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
        return new AsyncUncaughtExceptionHandlerEx();
    }

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        ThreadPoolTaskScheduler scheduler = this.taskScheduler();
        taskRegistrar.setTaskScheduler((TaskScheduler)scheduler);
    }

    @Bean
    public ThreadPoolTaskScheduler taskScheduler() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setPoolSize(this.asyncProperties.getMaxPoolSize());
        scheduler.setThreadNamePrefix("flood-async-schedule-executor-");
        scheduler.setAwaitTerminationSeconds(60);
        scheduler.setWaitForTasksToCompleteOnShutdown(true);
        return scheduler;
    }
}

