/*
 * Decompiled with CFR 0.152.
 */
package com.zlf.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.zlf.config.DingRobotConfig;
import com.zlf.config.RobotProperties;
import com.zlf.dto.DingRobotMsgDto;
import com.zlf.enums.DingRobotMsgTypeEnum;
import com.zlf.service.ThreadPoolService;
import com.zlf.type.DingRobotMsg;
import com.zlf.type.DingRobotMsgActionCardButton;
import com.zlf.type.DingRobotMsgAt;
import com.zlf.type.DingRobotMsgFeedCard;
import com.zlf.type.DingRobotMsgFeedCardLink;
import com.zlf.type.DingRobotMsgLink;
import com.zlf.type.DingRobotMsgMarkdown;
import com.zlf.type.DingRobotMsgMoreActionCard;
import com.zlf.type.DingRobotMsgSingleActionCard;
import com.zlf.type.DingRobotMsgText;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingRobotService {
    private static final Logger log = LoggerFactory.getLogger(DingRobotService.class);
    private DingRobotConfig dingRobotConfig;

    public DingRobotService(DingRobotConfig dingRobotConfig) {
        this.dingRobotConfig = dingRobotConfig;
    }

    public String buildMarkDownContent(Map<String, Object> map) {
        DingRobotMsgDto dto = new DingRobotMsgDto(map);
        String mdContent = dto.buildMarkdownMsgContent();
        return mdContent;
    }

    public void sendMsgByIndex0(DingRobotMsg msg) {
        String msgStr = this.buildMsg1(msg);
        this.send(0, msgStr);
    }

    public void sendMsgByIndex0(DingRobotMsg msg, DingRobotMsgAt at) {
        String msgStr = this.buildMsg1(msg, at);
        this.send(0, msgStr);
    }

    public void sendMsgByIndex(int index, DingRobotMsg msg) {
        String msgStr = this.buildMsg1(msg);
        this.send(index, msgStr);
    }

    public void sendMsgByIndex(int index, DingRobotMsg msg, DingRobotMsgAt at) {
        String msgStr = this.buildMsg0(msg, at);
        this.send(index, msgStr);
    }

    public String buildMsg1(DingRobotMsg msg) {
        return this.buildMsg0(msg, null);
    }

    public String buildMsg1(DingRobotMsg msg, DingRobotMsgAt at) {
        return this.buildMsg0(msg, at);
    }

    public String buildMsg0(DingRobotMsg msg, DingRobotMsgAt at) {
        this.checkMsg(msg, at);
        HashMap<String, Object> param = new HashMap<String, Object>(3);
        DingRobotMsgTypeEnum msgTypeEnum = msg.getMsgType();
        String msgType = msgTypeEnum.getMsgType();
        param.put("msgtype", msgType);
        param.put(msgType, msg);
        if (msg instanceof DingRobotMsgText) {
            if (Objects.isNull(at)) {
                param.put("at", new DingRobotMsgAt());
            } else {
                param.put("at", at);
            }
        } else if (msg instanceof DingRobotMsgMarkdown) {
            if (Objects.isNull(at)) {
                param.put("at", new DingRobotMsgAt());
            } else {
                param.put("at", at);
            }
        }
        return JSON.toJSONString(param);
    }

    private void checkMsg(DingRobotMsg msg, DingRobotMsgAt at) {
        block18: {
            block22: {
                block21: {
                    block20: {
                        block19: {
                            block17: {
                                if (Objects.isNull(msg)) {
                                    throw new RuntimeException("DingRobotMsg\u53c2\u6570\u4e0d\u4e3a\u7a7a");
                                }
                                if (!(msg instanceof DingRobotMsgText)) break block17;
                                DingRobotMsgText msgText = (DingRobotMsgText)msg;
                                if (StringUtils.isEmpty((CharSequence)msgText.getContent())) {
                                    throw new RuntimeException("\u53d1\u9001" + msgText.getMsgType().getMsgType() + "\u7c7b\u578b\u6d88\u606f\u7684content\u4e0d\u4e3a\u7a7a");
                                }
                                this.doContent(msg, at);
                                break block18;
                            }
                            if (!(msg instanceof DingRobotMsgMarkdown)) break block19;
                            DingRobotMsgMarkdown msgMarkdown = (DingRobotMsgMarkdown)msg;
                            if (StringUtils.isEmpty((CharSequence)msgMarkdown.getTitle())) {
                                throw new RuntimeException("\u53d1\u9001" + msgMarkdown.getMsgType().getMsgType() + "\u7c7b\u578b\u6d88\u606f\u7684title\u4e0d\u4e3a\u7a7a");
                            }
                            if (StringUtils.isEmpty((CharSequence)msgMarkdown.getText())) {
                                throw new RuntimeException("\u53d1\u9001" + msgMarkdown.getMsgType().getMsgType() + "\u7c7b\u578b\u6d88\u606f\u7684text\u4e0d\u4e3a\u7a7a");
                            }
                            this.doContent(msg, at);
                            break block18;
                        }
                        if (!(msg instanceof DingRobotMsgLink)) break block20;
                        DingRobotMsgLink msgLink = (DingRobotMsgLink)msg;
                        if (StringUtils.isEmpty((CharSequence)msgLink.getTitle())) {
                            throw new RuntimeException("\u53d1\u9001" + msgLink.getMsgType().getMsgType() + "\u7c7b\u578b\u6d88\u606f\u7684title\u4e0d\u4e3a\u7a7a");
                        }
                        if (StringUtils.isEmpty((CharSequence)msgLink.getText())) {
                            throw new RuntimeException("\u53d1\u9001" + msgLink.getMsgType().getMsgType() + "\u7c7b\u578b\u6d88\u606f\u7684text\u4e0d\u4e3a\u7a7a");
                        }
                        break block18;
                    }
                    if (!(msg instanceof DingRobotMsgSingleActionCard)) break block21;
                    DingRobotMsgSingleActionCard singleActionCard = (DingRobotMsgSingleActionCard)msg;
                    if (StringUtils.isEmpty((CharSequence)singleActionCard.getTitle())) {
                        throw new RuntimeException("\u53d1\u9001" + singleActionCard.getMsgType().getMsgType() + "\u7c7b\u578b\u6d88\u606f\u7684title\u4e0d\u4e3a\u7a7a");
                    }
                    if (StringUtils.isEmpty((CharSequence)singleActionCard.getText())) {
                        throw new RuntimeException("\u53d1\u9001" + singleActionCard.getMsgType().getMsgType() + "\u7c7b\u578b\u6d88\u606f\u7684text\u4e0d\u4e3a\u7a7a");
                    }
                    if (StringUtils.isEmpty((CharSequence)singleActionCard.getSingleTitle())) {
                        throw new RuntimeException("\u53d1\u9001" + singleActionCard.getMsgType().getMsgType() + "\u7c7b\u578b\u6d88\u606f\u7684singleTitle\u4e0d\u4e3a\u7a7a");
                    }
                    if (StringUtils.isEmpty((CharSequence)singleActionCard.getSingleURL())) {
                        throw new RuntimeException("\u53d1\u9001" + singleActionCard.getMsgType().getMsgType() + "\u7c7b\u578b\u6d88\u606f\u7684singleURL\u4e0d\u4e3a\u7a7a");
                    }
                    break block18;
                }
                if (!(msg instanceof DingRobotMsgMoreActionCard)) break block22;
                DingRobotMsgMoreActionCard moreActionCard = (DingRobotMsgMoreActionCard)msg;
                if (StringUtils.isEmpty((CharSequence)moreActionCard.getTitle())) {
                    throw new RuntimeException("\u53d1\u9001" + moreActionCard.getMsgType().getMsgType() + "\u7c7b\u578b\u6d88\u606f\u7684title\u4e0d\u4e3a\u7a7a");
                }
                if (StringUtils.isEmpty((CharSequence)moreActionCard.getText())) {
                    throw new RuntimeException("\u53d1\u9001" + moreActionCard.getMsgType().getMsgType() + "\u7c7b\u578b\u6d88\u606f\u7684text\u4e0d\u4e3a\u7a7a");
                }
                if (CollectionUtil.isEmpty(moreActionCard.getBtns())) {
                    throw new RuntimeException("\u53d1\u9001" + moreActionCard.getMsgType().getMsgType() + "\u7c7b\u578b\u6d88\u606f\u7684btns\u4e0d\u4e3a\u7a7a");
                }
                List<DingRobotMsgActionCardButton> btns = moreActionCard.getBtns();
                for (DingRobotMsgActionCardButton btn : btns) {
                    if (StringUtils.isEmpty((CharSequence)btn.getTitle())) {
                        throw new RuntimeException("\u53d1\u9001" + moreActionCard.getMsgType().getMsgType() + "\u7c7b\u578b\u6d88\u606f\u7684btns\u4e2dtitle\u4e0d\u4e3a\u7a7a");
                    }
                    if (!StringUtils.isEmpty((CharSequence)btn.getActionURL())) continue;
                    throw new RuntimeException("\u53d1\u9001" + moreActionCard.getMsgType().getMsgType() + "\u7c7b\u578b\u6d88\u606f\u7684btns\u4e2dactionURL\u4e0d\u4e3a\u7a7a");
                }
                break block18;
            }
            if (!(msg instanceof DingRobotMsgFeedCard)) break block18;
            DingRobotMsgFeedCard feedCard = (DingRobotMsgFeedCard)msg;
            if (CollectionUtil.isEmpty(feedCard.getLinks())) {
                throw new RuntimeException("\u53d1\u9001" + feedCard.getMsgType().getMsgType() + "\u7c7b\u578b\u6d88\u606f\u7684links\u4e0d\u4e3a\u7a7a");
            }
            List<DingRobotMsgFeedCardLink> links = feedCard.getLinks();
            for (DingRobotMsgFeedCardLink link : links) {
                if (!StringUtils.isEmpty((CharSequence)link.getTitle())) continue;
                throw new RuntimeException("\u53d1\u9001" + feedCard.getMsgType().getMsgType() + "\u7c7b\u578b\u6d88\u606f\u7684links\u4e2dtitle\u4e0d\u4e3a\u7a7a");
            }
        }
    }

    private void doContent(DingRobotMsg msg, DingRobotMsgAt at) {
        if (Objects.nonNull(at) && CollectionUtil.isNotEmpty(at.getAtUserIds())) {
            List<String> atUserIds = at.getAtUserIds();
            log.info("doContent.atUserIds:{}", (Object)JSON.toJSONString(atUserIds));
            HashSet<String> atUserIdsSet = new HashSet<String>(atUserIds);
            ArrayList<String> atUserIdsNew = new ArrayList<String>(atUserIdsSet);
            log.info("doContent.atUserIdsNew:{}", (Object)JSON.toJSONString(atUserIdsNew));
            at.setAtUserIds(atUserIdsNew);
            StringBuffer sb = new StringBuffer();
            atUserIdsNew.forEach(e -> sb.append("@" + e));
            String userIdsNewStr = sb.toString();
            log.info("DingRobotService.doContent.userIdsNewStr:{}", (Object)userIdsNewStr);
            if (msg instanceof DingRobotMsgText) {
                DingRobotMsgText msgText = (DingRobotMsgText)msg;
                msgText.setContent(msgText.getContent() + userIdsNewStr);
                log.info("DingRobotService.doContent.atUserIds.text-content:{}", (Object)msgText.getContent());
            } else if (msg instanceof DingRobotMsgMarkdown) {
                DingRobotMsgMarkdown msgMarkdown = (DingRobotMsgMarkdown)msg;
                msgMarkdown.setText(msgMarkdown.getText() + userIdsNewStr);
                log.info("DingRobotService.doContent.atUserIds.markdown-text:{}", (Object)msgMarkdown.getText());
            }
        }
        if (Objects.nonNull(at) && CollectionUtil.isNotEmpty(at.getAtMobiles())) {
            List<String> atMobiles = at.getAtMobiles();
            log.info("DingRobotService.doContent.atMobiles:{}", (Object)JSON.toJSONString(atMobiles));
            HashSet<String> atMobilesSet = new HashSet<String>(atMobiles);
            StringBuffer sb = new StringBuffer();
            atMobilesSet.forEach(e -> sb.append("@" + e));
            String atMobileStr = sb.toString();
            log.info("DingRobotService.doContent.atMobileStr:{}", (Object)atMobileStr);
            if (msg instanceof DingRobotMsgText) {
                DingRobotMsgText msgText = (DingRobotMsgText)msg;
                msgText.setContent(msgText.getContent() + atMobileStr);
                log.info("DingRobotService.doContent.atMobiles.text-content:{}", (Object)msgText.getContent());
            } else if (msg instanceof DingRobotMsgMarkdown) {
                DingRobotMsgMarkdown msgMarkdown = (DingRobotMsgMarkdown)msg;
                msgMarkdown.setText(msgMarkdown.getText() + atMobileStr);
                log.info("DingRobotService.doContent.atMobiles.markdown-text:{}", (Object)msgMarkdown.getText());
            }
        }
        if (Objects.nonNull(at) && (CollectionUtil.isNotEmpty(at.getAtMobiles()) || CollectionUtil.isNotEmpty(at.getAtUserIds()))) {
            at.setIsAtAll(Boolean.FALSE);
        }
    }

    private RobotProperties getRobotProperties(int index) {
        List<RobotProperties> rbs = this.dingRobotConfig.getRbs();
        if (CollectionUtil.isEmpty(rbs)) {
            throw new RuntimeException("\u6839\u636eindex\u83b7\u53d6RobotProperties\u4e3a\u7a7a");
        }
        return rbs.get(index);
    }

    private void send(int index, String msg) {
        try {
            RobotProperties p = this.getRobotProperties(index);
            Long timestamp = System.currentTimeMillis();
            String sign = this.getSign(p.getSecret(), timestamp);
            if (StringUtils.isEmpty((CharSequence)sign)) {
                log.error("\u3010\u53d1\u9001\u9489\u9489\u7fa4\u6d88\u606f\u3011sign\u4e0d\u4e3a\u7a7a,\u7b7e\u540d\u5f02\u5e38");
            }
            String url = "https://oapi.dingtalk.com/robot/send?access_token=" + p.getAccessToken() + "&timestamp=" + timestamp + "&sign=" + sign;
            ThreadPoolService.getInstance().execute(() -> {
                log.info("\u3010\u53d1\u9001\u9489\u9489\u7fa4\u6d88\u606f\u3011\u8bf7\u6c42\u53c2\u6570\uff1aurl = {}, msg = {}", (Object)url, (Object)msg);
                String res = HttpUtil.post((String)url, (String)msg);
                log.info("\u3010\u53d1\u9001\u9489\u9489\u7fa4\u6d88\u606f\u3011\u6d88\u606f\u54cd\u5e94\u7ed3\u679c\uff1a" + res);
            });
        }
        catch (Exception e) {
            log.error("\u3010\u53d1\u9001\u9489\u9489\u7fa4\u6d88\u606f\u3011\u8bf7\u6c42\u9489\u9489\u63a5\u53e3\u5f02\u5e38\uff0cmsg = {}", (Throwable)e);
        }
    }

    private String getSign(String secret, Long timestamp) {
        try {
            String stringToSign = timestamp + "\n" + secret;
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(secret.getBytes("UTF-8"), "HmacSHA256"));
            byte[] signData = mac.doFinal(stringToSign.getBytes("UTF-8"));
            String sign = URLEncoder.encode(new String(Base64.encodeBase64((byte[])signData)), "UTF-8");
            log.info("\u3010\u53d1\u9001\u9489\u9489\u7fa4\u6d88\u606f\u3011\u83b7\u53d6\u5230\u7b7e\u540dsign = {}", (Object)sign);
            return sign;
        }
        catch (Exception e) {
            log.error("\u3010\u53d1\u9001\u9489\u9489\u7fa4\u6d88\u606f\u3011\u8ba1\u7b97\u7b7e\u540d\u5f02\u5e38\uff0cerrMsg = {}", (Throwable)e);
            return null;
        }
    }
}

