/*
 * Decompiled with CFR 0.152.
 */
package com.zlf.service;

import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolService {
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolService.class);
    private static final int DEFAULT_CORE_SIZE = Runtime.getRuntime().availableProcessors();
    private static final int MAX_QUEUE_SIZE = Runtime.getRuntime().availableProcessors();
    private static final int QUEUE_INIT_MAX_SIZE = 500;
    private static volatile ThreadPoolExecutor executor;

    private ThreadPoolService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ThreadPoolExecutor getInstance() {
        if (ThreadPoolService.executor != null) return ThreadPoolService.executor;
        Class<ThreadPoolService> clazz = ThreadPoolService.class;
        synchronized (ThreadPoolService.class) {
            if (ThreadPoolService.executor != null) return ThreadPoolService.executor;
            ThreadPoolService.executor = new ThreadPoolExecutor(DEFAULT_CORE_SIZE, MAX_QUEUE_SIZE, 10L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(500), Executors.defaultThreadFactory(), (r, executor) -> {
                try {
                    executor.getQueue().put(r);
                }
                catch (InterruptedException e) {
                    log.error("\u7ebf\u7a0b\u5904\u7406\u62d2\u7edd\u7b56\u7565\u5931\u8d25:{}", (Object)e.getMessage());
                }
            });
            // ** MonitorExit[var0] (shouldn't be in output)
            return ThreadPoolService.executor;
        }
    }

    public void execute(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        executor.execute(runnable);
    }

    public void cancel(Runnable runnable) {
        if (executor != null) {
            executor.getQueue().remove(runnable);
        }
    }
}

