/*
 * Decompiled with CFR 0.152.
 */
package com.zlf.uitils;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;

public class MarkdownUtils {
    public static SectionBuilder of() {
        return new SectionBuilder(new Section(Section.Type.NORMAL, null, null, null, 0));
    }

    public static void write(String str, String path) {
        try (FileOutputStream fileOutputStream = new FileOutputStream(path);
             OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8);){
            outputStreamWriter.write(str);
            outputStreamWriter.flush();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class MdParser {
        private MdParser() {
        }

        public String parse(Section sec) {
            Section root = this.findRoot(sec);
            return this.doParse(root, root).toString().trim();
        }

        private Section findRoot(Section sec) {
            if (sec.getParent() == null) {
                return sec;
            }
            return this.findRoot(sec.getParent());
        }

        private StringBuilder doParse(Section cur, Section root) {
            if (cur == null) {
                return null;
            }
            if (cur.childIsEmpty()) {
                return cur.parse(new StringBuilder());
            }
            StringBuilder childData = new StringBuilder();
            for (Section child : cur.getChildren()) {
                StringBuilder part = this.doParse(child, root);
                if (part == null) continue;
                childData.append((CharSequence)part);
            }
            return cur.parse(childData).append(cur.getParent() == root ? Character.valueOf('\n') : "");
        }
    }

    public static class TableDataBuilder {
        private final Section parentSec;
        private final SectionBuilder parentBuilder;
        private Object[][] tableData;

        private TableDataBuilder(Section parentSec, SectionBuilder parentBuilder) {
            this.parentSec = parentSec;
            this.parentBuilder = parentBuilder;
        }

        public TableDataBuilder data(Object[][] table) {
            if (table != null && table.length > 0 && table[0].length > 0) {
                this.tableData = table;
            }
            return this;
        }

        public TableDataBuilder data(Object[] title, Object[][] data) {
            if (title == null && data != null) {
                return this.data(data);
            }
            if (data != null && data.length > 0 && data[0].length > 0) {
                int minCol = Math.min(title.length, data[0].length);
                this.tableData = new Object[data.length + 1][minCol];
                this.tableData[0] = Arrays.copyOfRange(title, 0, minCol);
                for (int i = 0; i < data.length; ++i) {
                    this.tableData[i + 1] = Arrays.copyOfRange(data[i], 0, minCol);
                }
            }
            return this;
        }

        public SectionBuilder endTable() {
            this.parentSec.addChild(new Section(Section.Type.TABLE, this.tableData, this.parentSec, null, this.parentSec.getDepth()));
            return this.parentBuilder;
        }
    }

    public static class SectionBuilder {
        private static final MdParser parser = new MdParser();
        private final Section curSec;
        private Section parentSec;
        private SectionBuilder parentBuilder;

        private SectionBuilder(Section curSec) {
            this.curSec = curSec;
        }

        private SectionBuilder(Section curSec, Section parentSec, SectionBuilder parentBuilder) {
            this.curSec = curSec;
            this.parentSec = parentSec;
            this.parentBuilder = parentBuilder;
        }

        public SectionBuilder text(String text) {
            return this.text(text, (String)null);
        }

        public SectionBuilder text(String name, String value) {
            if (name != null) {
                List<Fonts> values = value != null ? Collections.singletonList(Fonts.of(value)) : Collections.emptyList();
                this.curSec.addChild(new Section(Section.Type.NORMAL, new MetaData(MetaData.Type.NORMAL, Fonts.of(name, new Style[]{null}), values), this.curSec, null, this.curSec.getDepth()));
            }
            return this;
        }

        public SectionBuilder text(String text, Style ... style) {
            if (text != null) {
                this.curSec.addChild(new Section(Section.Type.NORMAL, new MetaData(Fonts.of(text, style)), this.curSec, null, this.curSec.getDepth()));
            }
            return this;
        }

        public SectionBuilder text(Collection<String> values) {
            if (values != null && !values.isEmpty()) {
                this.text(null, values);
            }
            return this;
        }

        public SectionBuilder text(String name, Collection<String> values) {
            if (values == null || values.size() <= 0) {
                return this.text(name);
            }
            return this.text(name, null, values);
        }

        public SectionBuilder text(String name, Style valueStyle, Collection<String> values) {
            if (values == null || values.size() <= 0) {
                return this.text(name);
            }
            if (valueStyle == null) {
                valueStyle = Style.NORMAL;
            }
            ArrayList<Fonts> ele = new ArrayList<Fonts>(values.size());
            for (String value : values) {
                ele.add(Fonts.of(value, valueStyle));
            }
            this.curSec.addChild(new Section(Section.Type.NORMAL, new MetaData(Fonts.of(name), ele), this.curSec, null, this.curSec.getDepth()));
            return this;
        }

        public SectionBuilder bigTitle(String title) {
            if (title != null && title.length() != 0) {
                this.curSec.addChild(new Section(Section.Type.BIG_TITLE, new MetaData(Fonts.of(title)), this.curSec, null, this.curSec.getDepth()));
            }
            return this;
        }

        public SectionBuilder title(String title) {
            return this.title(title, Style.NORMAL);
        }

        public SectionBuilder title(String title, Style color) {
            if (title != null && title.length() != 0) {
                this.curSec.addChild(new Section(Section.Type.TITLE, new MetaData(Fonts.of(title, color)), this.curSec, null, this.curSec.getDepth()));
            }
            return this;
        }

        public SectionBuilder title(String title, Fonts ... label) {
            return this.title(title, (Style)null, label);
        }

        public SectionBuilder title(String title, Style titleColor, Fonts ... label) {
            if (title != null && title.length() != 0) {
                if (titleColor == null) {
                    titleColor = Style.NORMAL;
                }
                List<Fonts> labelList = label != null ? Arrays.asList(label) : Collections.emptyList();
                this.curSec.addChild(new Section(Section.Type.TITLE, new MetaData(Fonts.of(title, titleColor), labelList), this.curSec, null, this.curSec.getDepth()));
            }
            return this;
        }

        public SectionBuilder subTitle(String title) {
            if (title != null && title.length() != 0) {
                this.curSec.addChild(new Section(Section.Type.SUBTITLE, new MetaData(Fonts.of(title)), this.curSec, null, this.curSec.getDepth()));
            }
            return this;
        }

        public SectionBuilder ref() {
            Section refSection = new Section(Section.Type.REF, null, this.curSec, new ArrayList(), this.curSec.getDepth());
            this.curSec.addChild(refSection);
            return new SectionBuilder(refSection, this.curSec, this);
        }

        public SectionBuilder endRef() {
            return this.parentBuilder != null ? this.parentBuilder : this;
        }

        public TableDataBuilder table() {
            return new TableDataBuilder(this.curSec, this);
        }

        public SectionBuilder link(String url) {
            return this.link(null, url);
        }

        public SectionBuilder link(String name, String url) {
            if (name == null || name.length() == 0) {
                name = url;
            }
            if (url != null && url.length() != 0) {
                MetaData links = new MetaData(MetaData.Type.LINK, Fonts.of(name), Collections.singletonList(Fonts.of(url)));
                this.curSec.addChild(new Section(Section.Type.NORMAL, links, this.curSec, null, this.curSec.getDepth()));
            }
            return this;
        }

        public SectionBuilder links(Map<String, String> urlMappings) {
            return this.links(null, urlMappings);
        }

        public SectionBuilder links(String name, Map<String, String> urlMappings) {
            if (urlMappings != null && !urlMappings.isEmpty()) {
                ArrayList<Fonts> serialUrlInfos = new ArrayList<Fonts>();
                for (Map.Entry<String, String> entry : urlMappings.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    serialUrlInfos.add(Fonts.of(key != null ? key : ""));
                    serialUrlInfos.add(Fonts.of(value != null ? value : ""));
                }
                Fonts wrappedName = name != null && name.length() != 0 ? Fonts.of(name) : Fonts.EMPTY;
                MetaData linksGroup = new MetaData(MetaData.Type.LINK_LIST, wrappedName, serialUrlInfos);
                this.curSec.addChild(new Section(Section.Type.NORMAL, linksGroup, this.curSec, null, this.curSec.getDepth()));
            }
            return this;
        }

        public SectionBuilder photo(String name, String url) {
            if (name == null || name.length() == 0) {
                name = url;
            }
            if (url != null && url.length() != 0) {
                MetaData links = new MetaData(MetaData.Type.PHOTO, Fonts.of(name), Collections.singletonList(Fonts.of(url)));
                this.curSec.addChild(new Section(Section.Type.NORMAL, links, this.curSec, null, this.curSec.getDepth()));
            }
            return this;
        }

        public SectionBuilder photo(String url) {
            return this.photo(null, url);
        }

        public SectionBuilder ol() {
            int depth = this.curSec.getType() == Section.Type.ORDER_LIST || this.curSec.getType() == Section.Type.UN_ORDER_LIST ? this.curSec.getDepth() + 1 : this.curSec.getDepth();
            Section OrderListSec = new Section(Section.Type.ORDER_LIST, null, this.curSec, new ArrayList(), depth);
            this.curSec.addChild(OrderListSec);
            return new SectionBuilder(OrderListSec, this.curSec, this);
        }

        public SectionBuilder endOl() {
            return this.parentBuilder != null ? this.parentBuilder : this;
        }

        public SectionBuilder ul() {
            int depth = this.curSec.getType() == Section.Type.ORDER_LIST || this.curSec.getType() == Section.Type.UN_ORDER_LIST ? this.curSec.getDepth() + 1 : this.curSec.getDepth();
            Section unOrderListSec = new Section(Section.Type.UN_ORDER_LIST, null, this.curSec, new ArrayList(), depth);
            this.curSec.addChild(unOrderListSec);
            return new SectionBuilder(unOrderListSec, this.curSec, this);
        }

        public SectionBuilder endUl() {
            return this.parentBuilder != null ? this.parentBuilder : this;
        }

        public SectionBuilder code() {
            Section codeSec = new Section(Section.Type.CODE, null, this.curSec, new ArrayList(), this.curSec.getDepth());
            this.curSec.addChild(codeSec);
            return new SectionBuilder(codeSec, this.curSec, this);
        }

        public SectionBuilder code(String languageType) {
            if (languageType == null) {
                languageType = "";
            }
            Section codeSec = new Section(Section.Type.CODE, null, this.curSec, new ArrayList(), this.curSec.getDepth());
            codeSec.setLanguageType(languageType);
            this.curSec.addChild(codeSec);
            return new SectionBuilder(codeSec, this.curSec, this);
        }

        public SectionBuilder endCode() {
            return this.parentBuilder != null ? this.parentBuilder : this;
        }

        public SectionBuilder br() {
            this.curSec.addChild(new Section(Section.Type.BR, new MetaData(MetaData.Type.BR), this.parentSec, null, this.curSec.getDepth()));
            return this;
        }

        public String build() {
            return parser.parse(this.curSec);
        }
    }

    private static class Section {
        private final int depth;
        private Type type;
        private Object data;
        private Section parent;
        private List<Section> children;
        private String languageType = "";

        private Section(Type type, Object data, Section parent, List<Section> children, int depth) {
            this.type = type;
            this.data = data;
            this.parent = parent;
            this.children = children;
            this.depth = depth;
        }

        public Section setLanguageType(String languageType) {
            this.languageType = languageType;
            return this;
        }

        public void addChild(Section child) {
            this.lazyInitChildren();
            this.children.add(child);
        }

        public boolean childIsEmpty() {
            return this.children == null || this.children.isEmpty();
        }

        private StringBuilder parse(StringBuilder latestData) {
            switch (this.type) {
                case LINK: 
                case NORMAL: {
                    latestData.append('\n').append(this.parseData(""));
                    return latestData;
                }
                case BIG_TITLE: {
                    latestData.append('\n').append(this.parseData("## "));
                    return latestData;
                }
                case TITLE: {
                    latestData.append('\n').append(this.parseData("### "));
                    return latestData;
                }
                case SUBTITLE: {
                    latestData.append('\n').append(this.parseData("#### "));
                    return latestData;
                }
                case REF: {
                    return this.parseRefSection(latestData);
                }
                case CODE: {
                    StringBuilder codeBlock = new StringBuilder(latestData.length() + 10);
                    codeBlock.append("\n```").append(this.languageType).append((CharSequence)latestData).append("\n```");
                    return codeBlock;
                }
                case ORDER_LIST: {
                    return this.parseOrderListSection(latestData);
                }
                case UN_ORDER_LIST: {
                    return this.parseUnOrderListSection(latestData);
                }
                case TABLE: {
                    return this.parseTableSection(latestData);
                }
                case BR: {
                    return latestData.append(this.parseData(""));
                }
            }
            return latestData;
        }

        private String parseData(String prefix) {
            if (this.data == null) {
                return "";
            }
            return prefix + this.data;
        }

        private StringBuilder parseRefSection(StringBuilder latestData) {
            char[] chars = latestData.toString().toCharArray();
            if (chars.length <= 0) {
                return latestData;
            }
            StringBuilder data = new StringBuilder(chars.length * 2);
            if (chars[0] != '\n') {
                data.append("> ");
            }
            int last = 0;
            for (int n : chars) {
                if (last == 10) {
                    data.append("> ");
                }
                data.append((char)n);
                last = n;
            }
            return data;
        }

        private StringBuilder parseOrderListSection(StringBuilder latestData) {
            char[] chars = latestData.toString().toCharArray();
            if (chars.length <= 0) {
                return latestData;
            }
            StringBuilder data = new StringBuilder(chars.length * 2);
            String padding = String.join((CharSequence)"", Collections.nCopies(this.depth * 4, " "));
            int order = 1;
            if (chars[0] != '\n') {
                data.append(padding).append(order++).append(". ");
            }
            int last = 0;
            for (int n : chars) {
                if (last == 10 && n != 10 && n != 32) {
                    data.append(padding).append(order++).append(". ");
                }
                data.append((char)n);
                last = n;
            }
            return data;
        }

        private StringBuilder parseUnOrderListSection(StringBuilder latestData) {
            char[] chars = latestData.toString().toCharArray();
            if (chars.length <= 0) {
                return latestData;
            }
            StringBuilder data = new StringBuilder(chars.length * 2);
            String padding = String.join((CharSequence)"", Collections.nCopies(this.depth * 4, " "));
            if (chars[0] != '\n') {
                data.append(padding).append("- ");
            }
            int last = 0;
            for (int n : chars) {
                if (last == 10 && n != 10 && n != 32) {
                    data.append(padding).append("- ");
                }
                data.append((char)n);
                last = n;
            }
            return data;
        }

        private StringBuilder parseTableSection(StringBuilder latestData) {
            Object[][] tableData;
            if (this.data != null && (tableData = (Object[][])this.data).length > 0 && tableData[0].length > 0) {
                StringJoiner titles = new StringJoiner(" | ");
                StringJoiner extras = new StringJoiner(" | ");
                titles.add("");
                for (Object t : tableData[0]) {
                    titles.add(t != null ? t.toString() : "");
                    extras.add("----");
                }
                titles.add("");
                latestData.append("\n\n").append(titles).append("\n| ").append(extras).append(" |");
                for (int i = 1; i < tableData.length; ++i) {
                    StringJoiner dataJoiner = new StringJoiner(" | ");
                    for (int j = 0; j < tableData[i].length; ++j) {
                        dataJoiner.add(tableData[i][j] != null ? tableData[i][j].toString() : "");
                    }
                    latestData.append('\n').append("| ").append(dataJoiner).append(" |");
                }
            }
            return latestData.append('\n');
        }

        private void lazyInitChildren() {
            if (this.children == null) {
                this.children = new ArrayList<Section>();
            }
        }

        public Type getType() {
            return this.type;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public Object getData() {
            return this.data;
        }

        public void setData(Object data) {
            this.data = data;
        }

        public Section getParent() {
            return this.parent;
        }

        public void setParent(Section parent) {
            this.parent = parent;
        }

        public List<Section> getChildren() {
            return this.children;
        }

        public void setChildren(List<Section> children) {
            this.children = children;
        }

        public int getDepth() {
            return this.depth;
        }

        private static enum Type {
            NORMAL,
            BIG_TITLE,
            TITLE,
            SUBTITLE,
            REF,
            CODE,
            TABLE,
            ORDER_LIST,
            UN_ORDER_LIST,
            LINK,
            BR;

        }
    }

    public static class MetaData {
        public static final String DEFAULT_SEPARATOR = "\uff1a";
        public static final String DEFAULT_VALUE_SEPARATOR = " | ";
        public static final String LINK_TEMPLATE = "[%s](%s)";
        public static final String PHOTO_TEMPLATE = "![%s](%s)";
        private final Type type;
        private final Fonts text;
        private final Collection<Fonts> values;
        private final String separator = "\uff1a";
        private final String valueSeparator = " | ";

        public MetaData(Fonts text) {
            this(text, null);
        }

        public MetaData(Type type) {
            this(type, null, null);
        }

        public MetaData(Fonts text, Collection<Fonts> values) {
            this(Type.NORMAL, text, values);
        }

        public MetaData(Type type, Fonts text, Collection<Fonts> values) {
            this.type = type;
            this.text = text;
            this.values = values;
        }

        public String toString() {
            return this.generateString(this.valueSeparator);
        }

        private String generateString(String valueSeparator) {
            boolean hasValues = this.values != null && !this.values.isEmpty();
            boolean hasText = this.text != null && !this.text.isEmpty();
            StringJoiner joiner = new StringJoiner(valueSeparator);
            String ret = "";
            switch (this.type) {
                case NORMAL: {
                    if (hasText && hasValues) {
                        this.values.forEach(v -> joiner.add(v.toString()));
                        ret = this.text + DEFAULT_SEPARATOR + joiner;
                        break;
                    }
                    if (!hasText && hasValues) {
                        this.values.forEach(v -> joiner.add(v.toString()));
                        ret = joiner.toString();
                        break;
                    }
                    if (!hasText) break;
                    ret = this.text.toString();
                    break;
                }
                case LINK: {
                    if (hasText && hasValues) {
                        Fonts fonts = this.values.stream().findFirst().orElse(null);
                        if (fonts == null) break;
                        ret = String.format(LINK_TEMPLATE, this.text, fonts);
                        break;
                    }
                    if (!hasText && hasValues) {
                        Fonts url = this.values.stream().findFirst().orElse(null);
                        if (url == null) break;
                        ret = String.format(LINK_TEMPLATE, url, url);
                        break;
                    }
                    if (!hasText) break;
                    ret = String.format(LINK_TEMPLATE, this.text, this.text);
                    break;
                }
                case LINK_LIST: {
                    if (hasText && hasValues) {
                        ret = this.text + DEFAULT_SEPARATOR + this.generateLinkList(this.values);
                        break;
                    }
                    if (!hasText && hasValues) {
                        ret = this.generateLinkList(this.values);
                        break;
                    }
                    if (!hasText) break;
                    ret = String.format(LINK_TEMPLATE, this.text, this.text);
                    break;
                }
                case PHOTO: {
                    if (hasText && hasValues) {
                        Fonts fonts = this.values.stream().findFirst().orElse(null);
                        if (fonts == null) break;
                        ret = String.format(PHOTO_TEMPLATE, this.text, fonts);
                        break;
                    }
                    if (!hasText && hasValues) {
                        Fonts url = this.values.stream().findFirst().orElse(null);
                        if (url == null) break;
                        ret = String.format(PHOTO_TEMPLATE, url, url);
                        break;
                    }
                    if (!hasText) break;
                    ret = String.format(PHOTO_TEMPLATE, this.text, this.text);
                    break;
                }
                case BR: {
                    ret = "\n<br>";
                }
            }
            return ret;
        }

        private String generateLinkList(Collection<Fonts> values) {
            boolean isPairNum;
            if (values == null || values.isEmpty()) {
                return "";
            }
            Object[] valueArr = values.toArray();
            StringJoiner linkList = new StringJoiner(DEFAULT_VALUE_SEPARATOR);
            int i = 0;
            while (i + 1 < valueArr.length) {
                linkList.add(String.format(LINK_TEMPLATE, valueArr[i], valueArr[i + 1]));
                i += 2;
            }
            boolean bl = isPairNum = valueArr.length % 2 == 0;
            if (!isPairNum) {
                String lastUrl = valueArr[valueArr.length - 1].toString();
                linkList.add(String.format(LINK_TEMPLATE, lastUrl, lastUrl));
            }
            return linkList.toString();
        }

        private static enum Type {
            NORMAL,
            LINK,
            PHOTO,
            LINK_LIST,
            BR;

        }
    }

    public static class Fonts {
        public static final Fonts EMPTY = Fonts.of("");
        private final String text;
        private Set<Style> styles = Collections.emptySet();

        private Fonts(String text, Style ... style) {
            String string = this.text = text != null ? text : "";
            if (style != null) {
                this.styles = new HashSet<Style>(Arrays.asList(style));
            }
        }

        public static Fonts of(String text) {
            return new Fonts(text, Style.NORMAL);
        }

        public static Fonts of(String text, Style ... style) {
            return new Fonts(text, style);
        }

        public boolean isEmpty() {
            return this.text == null || this.text.isEmpty();
        }

        public String toString() {
            if (this.styles.contains((Object)Style.NORMAL)) {
                return this.text;
            }
            String last = this.text;
            for (Style style : this.styles) {
                last = this.parseStyle(last, style);
            }
            return last;
        }

        private String parseStyle(String text, Style style) {
            if (text == null || style == null) {
                return text;
            }
            switch (style) {
                case NORMAL: {
                    break;
                }
                case BOLD: {
                    return "**" + text + "**";
                }
                case ITALIC: {
                    return "*" + text + "*";
                }
                case RED: 
                case GREEN: 
                case BLUE: 
                case YELLOW: {
                    return "<font color='" + style.getName() + "'>" + text + "</font>";
                }
            }
            return text;
        }
    }

    public static enum Style {
        NORMAL("normal"),
        BOLD("bold"),
        ITALIC("italic"),
        RED("red"),
        GREEN("green"),
        GRAY("gray"),
        YELLOW("gold"),
        BLUE("blue");

        private final String name;

        private Style(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

