/*
 * Decompiled with CFR 0.152.
 */
package com.cdn.log.aspect;

import com.cdn.log.anno.Clog;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.MDC;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

@Aspect
public class ClogAspect {
    @Autowired
    private ApplicationContext applicationContext;
    private static final ExpressionParser EXPRESSION_PARSER = new SpelExpressionParser();

    @Around(value="@annotation(com.cdn.log.anno.Clog)")
    public Object preAuth(ProceedingJoinPoint point) throws Throwable {
        MethodSignature ms = (MethodSignature)point.getSignature();
        Method method = ms.getMethod();
        Object[] args = point.getArgs();
        Clog clog = method.getAnnotation(Clog.class);
        StringBuilder builder = new StringBuilder();
        String[] value = clog.value();
        StandardEvaluationContext context = this.getEvaluationContext(method, args);
        for (String s : value) {
            Expression expression = EXPRESSION_PARSER.parseExpression(s);
            Object value1 = expression.getValue((EvaluationContext)context);
            if (null == value1) continue;
            if (builder.length() > 0) {
                builder.append(clog.separator());
            }
            builder.append(value1);
        }
        builder.insert(0, MDC.get((String)"traceId") + "|");
        MDC.put((String)"traceId", (String)builder.toString());
        Object proceed = point.proceed();
        MDC.clear();
        return proceed;
    }

    private StandardEvaluationContext getEvaluationContext(Method method, Object[] args) {
        StandardEvaluationContext context = new StandardEvaluationContext();
        context.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)this.applicationContext));
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            context.setVariable(parameters[i].getName(), args[i]);
        }
        return context;
    }
}

