/*
 * Decompiled with CFR 0.152.
 */
package com.cdn.log.aspect;

import java.util.UUID;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.MDC;

@Aspect
public class ScheduledAop {
    @Pointcut(value="@annotation(org.springframework.scheduling.annotation.Scheduled)")
    public void scheduledMethods() {
    }

    @Before(value="scheduledMethods()")
    public void addTraceId() {
        MDC.put((String)"traceId", (String)UUID.randomUUID().toString());
    }

    @After(value="scheduledMethods()")
    public void removeTraceId(JoinPoint joinPoint) {
        MDC.remove((String)"traceId");
    }

    @AfterThrowing(value="scheduledMethods()")
    public void exRemoveId(JoinPoint joinPoint) {
        MDC.remove((String)"traceId");
    }
}

