/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j;

import com.cdn.log.config.ClogProperties;
import com.cdn.log.utils.IdUtil;
import javax.servlet.http.HttpServletRequest;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.aop.aspectj.AspectJExpressionPointcutAdvisor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ClogAopInterceptor
implements MethodInterceptor {
    @Autowired
    private ClogProperties clogProperties;
    final Logger logger = LoggerFactory.getLogger(this.getClass());

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        String s = MDC.get((String)"traceId");
        if (StringUtils.isEmpty((Object)s)) {
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            HttpServletRequest request = attributes.getRequest();
            String traceId = request.getHeader("traceId");
            MDC.put((String)"traceId", (String)(StringUtils.isEmpty((Object)traceId) ? IdUtil.simpleId() : traceId));
        }
        Object result = methodInvocation.proceed();
        MDC.remove((String)"traceId");
        return result;
    }

    @Bean
    public AspectJExpressionPointcutAdvisor logAdvisor() {
        AspectJExpressionPointcutAdvisor advisor = new AspectJExpressionPointcutAdvisor();
        advisor.setExpression("execution(* " + this.clogProperties.getControllerPackageName() + ".*.*(..))");
        advisor.setAdvice((Advice)this);
        this.logger.info("aop express is: {}", (Object)advisor.getExpression());
        return advisor;
    }
}

