/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.MDC;
import org.slf4j.spi.MDCAdapter;

public class ClogbackMDCAdapter
implements MDCAdapter {
    final ThreadLocal<Map<String, String>> copyOnThreadLocal = new InheritableThreadLocal<Map<String, String>>();
    private static final int WRITE_OPERATION = 1;
    private static final int MAP_COPY_OPERATION = 2;
    final ThreadLocal<Integer> lastOperation = new ThreadLocal();
    private static final ClogbackMDCAdapter mtcMDCAdapter = new ClogbackMDCAdapter();

    public static void getInstance() {
    }

    private Integer getAndSetLastOperation(int op) {
        Integer lastOp = this.lastOperation.get();
        this.lastOperation.set(op);
        return lastOp;
    }

    private boolean wasLastOpReadOrNull(Integer lastOp) {
        return lastOp == null || lastOp == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> duplicateAndInsertNewMap(Map<String, String> oldMap) {
        Map<String, String> newMap = Collections.synchronizedMap(new HashMap());
        if (oldMap != null) {
            Map<String, String> map = oldMap;
            synchronized (map) {
                newMap.putAll(oldMap);
            }
        }
        this.copyOnThreadLocal.set(newMap);
        return newMap;
    }

    public void put(String key, String val) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        Map<String, String> oldMap = this.copyOnThreadLocal.get();
        Integer lastOp = this.getAndSetLastOperation(1);
        if (!this.wasLastOpReadOrNull(lastOp) && oldMap != null) {
            oldMap.put(key, val);
        } else {
            Map<String, String> newMap = this.duplicateAndInsertNewMap(oldMap);
            newMap.put(key, val);
        }
    }

    public void remove(String key) {
        Map<String, String> oldMap;
        if (key != null && (oldMap = this.copyOnThreadLocal.get()) != null) {
            Integer lastOp = this.getAndSetLastOperation(1);
            if (this.wasLastOpReadOrNull(lastOp)) {
                Map<String, String> newMap = this.duplicateAndInsertNewMap(oldMap);
                newMap.remove(key);
            } else {
                oldMap.remove(key);
            }
        }
    }

    public void clear() {
        this.lastOperation.set(1);
        this.copyOnThreadLocal.remove();
    }

    public String get(String key) {
        Map<String, String> map = this.copyOnThreadLocal.get();
        return map != null && key != null ? map.get(key) : null;
    }

    public Map<String, String> getPropertyMap() {
        this.lastOperation.set(2);
        return this.copyOnThreadLocal.get();
    }

    public Set<String> getKeys() {
        Map<String, String> map = this.getPropertyMap();
        return map != null ? map.keySet() : null;
    }

    public Map<String, String> getCopyOfContextMap() {
        Map<String, String> hashMap = this.copyOnThreadLocal.get();
        return hashMap == null ? null : new HashMap<String, String>(hashMap);
    }

    public void setContextMap(Map contextMap) {
        this.lastOperation.set(1);
        Map newMap = Collections.synchronizedMap(new HashMap());
        newMap.putAll(contextMap);
        this.copyOnThreadLocal.set(newMap);
    }

    static {
        MDC.mdcAdapter = mtcMDCAdapter;
    }
}

