package com.cxy;

import com.cxy.common.boot.CxyCloudApplication;
import com.cxy.common.boot.CxyCloudBootstrap;
import com.cxy.test.TestBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ConfigurableApplicationContext;


import java.lang.management.ManagementFactory;

/*********************************************************
 * 文件名称：${NAME}.java
 * 系统名称：CXY自定义系统
 * 模块名称：com.cxy
 * 功能说明：${TODO}
 * 开发人员 @author：caoxy31978
 * 开发时间 @date：${DATE} ${TIME}
 * 修改记录：程序版本  修改日期  修改人员  修改单号  修改说明
 *********************************************************/
@CxyCloudApplication
public class Main {
    @Autowired
    public TestBean testBean;

    public static void main(String[] args) {
        ConfigurableApplicationContext app = CxyCloudBootstrap.run(Main.class, args);
        System.out.println("--------------启动好了--------------");
        Main bean = app.getBean(Main.class);
        bean.testBean.sout();
    }

    public static String getPid() {
        try {
            String name = ManagementFactory.getRuntimeMXBean().getName();
            String[] names = name.split("@");
            return names[0];
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}