package com.cxy.common.banner;

import org.apache.commons.logging.Log;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StreamUtils;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;


/*********************************************************
 * 文件名称：CxyCloudBootstrapConfiguration.java
 * 系统名称：CXY自定义系统
 * 模块名称：com.cxy.common.config
 * 功能说明：参数配置
 * 开发人员 @author：caoxy31978
 * 开发时间 @date：2023/6/29 13:42
 * 修改记录：程序版本  修改日期  修改人员  修改单号  修改说明
 *********************************************************/
@Order
public class BannerConfiguration implements EnvironmentPostProcessor{
    private final Log LOGGER;

    public BannerConfiguration(DeferredLogFactory logFactory) {
        this.LOGGER = logFactory.getLog(BannerConfiguration.class);
    }
    @Override
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        String property =
                environment.getProperty(SpringApplication.BANNER_LOCATION_PROPERTY, SpringApplication.BANNER_LOCATION_PROPERTY_VALUE);
        ResourceLoader resourceLoader = application.getResourceLoader();
        resourceLoader = resourceLoader == null ? new DefaultResourceLoader(null) : resourceLoader;
        Resource resource = resourceLoader.getResource(property);
        try {
            String banner;
            if (resource.exists() && !resource.getURL().toExternalForm().contains("liquibase-core")) {
                Boolean varicoloredBannerEnabled = environment.getProperty("cxy.banner.local.varicolored.enabled", Boolean.class, true);
                if (!varicoloredBannerEnabled){
                    return;
                }
                banner = StreamUtils.copyToString(resource.getInputStream(), environment.getProperty("spring.banner.charset", Charset.class, StandardCharsets.UTF_8));
            } else {
                banner = BannerUtil.getBANNER();
            }
            String output = BannerUtil.convertColor(banner);
            File newBanner = File.createTempFile("banner", ".txt");
            String newBannerAbsolutePath = newBanner.getAbsolutePath();
            try(PrintWriter printWriter = new PrintWriter(newBanner)) {
                printWriter.print(output);
                environment.getPropertySources().addFirst(new MapPropertySource("proxy-banner",
                        Map.of(SpringApplication.BANNER_LOCATION_PROPERTY, "file:" + newBannerAbsolutePath)));
                LOGGER.debug("proxy banner success : " + newBannerAbsolutePath);
            }
        }
        catch (IOException ex) {
            // Ignore
        }
    }
}
