package com.cxy.common.banner;

import org.springframework.boot.ansi.AnsiColor;
import org.springframework.boot.ansi.AnsiOutput;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/*********************************************************
 * 文件名称：BannerUtil.java
 * 系统名称：CXY自定义系统
 * 模块名称：com.cxy.common.banner
 * 功能说明：
 * 开发人员 @author：caoxy31978
 * 开发时间 @date：2023/6/30 13:44
 * 修改记录：程序版本  修改日期  修改人员  修改单号  修改说明
 *********************************************************/
public class BannerUtil {

    private static final List<String> BANNERS = new ArrayList<>();

    static {
        BANNERS.add(
                        "                                                   ┏━┓     ┏━┓\n" +
                        "                                                  ┏┛ ┻━━━━━┛ ┻┓\n" +
                        "                                                  ┃           ┃\n" +
                        "                                                  ┃     ━     ┃\n" +
                        "                                                  ┃  ┳┛   ┗┳  ┃\n" +
                        "                                                  ┃           ┃\n" +
                        "                                                  ┃     ┻     ┃\n" +
                        "                                                  ┃           ┃\n" +
                        "                                                  ┗━┓     ┏━━━┛\n" +
                        "                                                    ┃     ┃   神兽保佑\n" +
                        "                                                    ┃     ┃   代码无BUG！\n" +
                        "                                                    ┃     ┗━━━━━━━━━┓\n" +
                        "                                                    ┃               ┣┓\n" +
                        "                                                    ┃               ┏┛\n" +
                        "                                                    ┗━┓ ┓ ┏━┳━┳ ┓ ┏━┛\n" +
                        "                                                      ┃ ┫ ┫   ┃ ┫ ┫\n" +
                        "                                                      ┗━┻━┛   ┗━┻━┛\n" +
                        "                                   ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^"
        );
        BANNERS.add(
                        "                                                      \\\\\n" +
                        "                                                       \\\\\n" +
                        "                                                        \\\\\\\\\\\\_ \\s\n" +
                        "                                                         \\\\` ,\\\\\n" +
                        "                                                 __,.-\"\" =__)\n" +
                        "                                               .\"\"        )\n" +
                        "                                          ,_/   ,    \\\\/\\\\_\n" +
                        "                                          \\\\_|    )_-\\\\ \\\\_-`\n" +
                        "                                            `-----` `--`\n" +
                        "                        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^"
        );
    }

    private static String clearColor(String banner) {
        Pattern pattern = Pattern.compile("\\$\\{AnsiColor\\.[a-zA-Z_]+}");
        Matcher matcher = pattern.matcher(banner);
        return matcher.replaceAll("");
    }

    private static String addColorEveryThing(String banner) {
        AnsiOutput.Enabled enabled = AnsiOutput.getEnabled();
        AnsiOutput.setEnabled(AnsiOutput.Enabled.ALWAYS);
        banner = Arrays.stream(banner.split("\n"))
                .map(line -> {
                            Pattern pattern = Pattern.compile("\\$\\{([^}]*)}");
                            Matcher matcher = pattern.matcher(line);
                            StringBuilder stringBuffer = new StringBuilder();
                            int start = 0;
                            Function<String,String> allCharsConvert =
                                    (text)->Arrays.stream(text.split("")).map(BannerUtil::addColor).collect(Collectors.joining());
                            while (matcher.find()) {
                                String text = line.substring(start, matcher.start());
                                stringBuffer.append(allCharsConvert.apply(text));
                                start = matcher.end();
                                stringBuffer.append(addColor(matcher.group()));
                            }
                            stringBuffer.append(allCharsConvert.apply(line.substring(start)));
                            return stringBuffer.toString();
                        }
                )
                .collect(Collectors.joining("\n"));
        AnsiOutput.setEnabled(enabled);
        return banner;
    }

    private static String addColor(String group) {
        // AnsiOutput.toString(values[random.nextInt(values.length)], str, AnsiColor.DEFAULT)
        AnsiColor[] values = Arrays.stream(AnsiColor.values()).filter(
                ansiColor -> Integer.parseInt(ansiColor.toString()) >= 91 &&
                        Integer.parseInt(ansiColor.toString()) <= 96
        ).toArray(AnsiColor[]::new);
        Random random = new Random();
        group = "${AnsiColor." + values[random.nextInt(values.length)].name() + "}" + group +
                "${AnsiColor.DEFAULT}";
        return group;
    }

    public static String convertColor(String banner) {
        return addColorEveryThing(clearColor(banner));
    }

    public static String getBANNER() {
        return BANNERS.get(new Random().nextInt(BANNERS.size()));
    }
}
