package com.cxy.common.banner;

import io.micrometer.common.util.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.ResourceBanner;
import org.springframework.core.io.ByteArrayResource;

/*********************************************************
 * 文件名称：cnmBanner.java
 * 系统名称：CXY自定义系统
 * 模块名称：com.cxy.common.banner
 * 功能说明：
 * 开发人员 @author：caoxy31978
 * 开发时间 @date：2023/6/28 17:30
 * 修改记录：程序版本  修改日期  修改人员  修改单号  修改说明
 *********************************************************/
@Slf4j
public class CxyBanner extends ResourceBanner{
    public CxyBanner(String resource) {
        super(new ByteArrayResource(StringUtils.isBlank(resource)?BannerUtil.getBANNER().getBytes(): resource.getBytes()));
    }
}
