package com.cxy.common.boot;

import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AliasFor;
import org.springframework.scheduling.annotation.EnableAsync;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/*********************************************************
 * 文件名称：CxyCloudApplication.java
 * 系统名称：CXY自定义系统
 * 模块名称：com.cxy.common.boot
 * 功能说明：启动注解
 * 开发人员 @author：caoxy31978
 * 开发时间 @date：2023/6/28 9:21
 * 修改记录：程序版本  修改日期  修改人员  修改单号  修改说明
 *********************************************************/
@Target({ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Inherited
@SpringBootApplication
@EnableAsync
public @interface CxyCloudApplication {
    @AliasFor(
            annotation = SpringBootApplication.class,
            attribute = "exclude"
    )
    Class<?>[] exclude() default {};

    @AliasFor(
            annotation = SpringBootApplication.class,
            attribute = "excludeName"
    )
    String[] excludeName() default {};

    @AliasFor(
            annotation = SpringBootApplication.class,
            attribute = "scanBasePackages"
    )
    String[] scanBasePackages() default {};

    @AliasFor(
            annotation = SpringBootApplication.class,
            attribute = "scanBasePackageClasses"
    )
    Class<?>[] scanBasePackageClasses() default {};

    @AliasFor(
            annotation = SpringBootApplication.class,
            attribute = "nameGenerator"
    )
    Class<? extends BeanNameGenerator> nameGenerator() default BeanNameGenerator.class;

    @AliasFor(
            annotation = SpringBootApplication.class,
            attribute = "proxyBeanMethods"
    )
    boolean proxyBeanMethods() default true;
}
