/*
 * Decompiled with CFR 0.152.
 */
package com.chm.converter.json;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.TypeReference;
import com.alibaba.fastjson2.annotation.JSONBuilder;
import com.alibaba.fastjson2.annotation.JSONCreator;
import com.alibaba.fastjson2.annotation.JSONField;
import com.alibaba.fastjson2.annotation.JSONType;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import com.chm.converter.core.Converter;
import com.chm.converter.core.JavaBeanInfo;
import com.chm.converter.core.exception.ConvertException;
import com.chm.converter.core.utils.ArrayUtil;
import com.chm.converter.core.utils.ListUtil;
import com.chm.converter.fastjson2.reader.Fastjson2ObjectReaderProvider;
import com.chm.converter.fastjson2.writer.Fastjson2ObjectWriterProvider;
import com.chm.converter.json.JsonConverter;
import com.google.auto.service.AutoService;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;

@AutoService(value={Converter.class})
public class Fastjson2Converter
implements JsonConverter {
    public static final List<Class<? extends Annotation>> FASTJSON_ANNOTATION_LIST = ListUtil.of((Object[])new Class[]{JSONCreator.class, JSONField.class, JSONBuilder.class, JSONType.class});
    public static final String FAST_JSON2_NAME = "com.alibaba.fastjson2.JSON";
    private JSONWriter.Feature[] writerFeatureArray = new JSONWriter.Feature[0];
    private JSONReader.Feature[] readerFeatureArray = new JSONReader.Feature[0];
    private final ObjectWriterProvider writerProvider = new Fastjson2ObjectWriterProvider((Converter)this, Fastjson2Converter::checkExistFastjson2Annotation);
    private final ObjectReaderProvider readerProvider = new Fastjson2ObjectReaderProvider((Converter)this, Fastjson2Converter::checkExistFastjson2Annotation);

    public void addWriterFeature(JSONWriter.Feature writerFeature) {
        this.writerFeatureArray = (JSONWriter.Feature[])ArrayUtil.append((Object[])this.writerFeatureArray, (Object[])new JSONWriter.Feature[]{writerFeature});
    }

    public void addReaderFeature(JSONReader.Feature readerFeature) {
        this.readerFeatureArray = (JSONReader.Feature[])ArrayUtil.append((Object[])this.readerFeatureArray, (Object[])new JSONReader.Feature[]{readerFeature});
    }

    public <T> T convertToJavaObject(String source, Class<T> targetType) {
        return this.privateConvertToJavaObject(source, targetType);
    }

    public <T> T convertToJavaObject(String source, Type targetType) {
        return this.privateConvertToJavaObject(source, targetType);
    }

    public <T> T convertToJavaObject(String source, TypeReference<T> typeReference) {
        return this.privateConvertToJavaObject(source, typeReference.getType());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T privateConvertToJavaObject(String source, Type targetType) {
        if (source == null) return null;
        if (source.isEmpty()) {
            return null;
        }
        JSONReader.Context readContext = new JSONReader.Context(this.readerProvider);
        try (JSONReader reader = JSONReader.of((JSONReader.Context)readContext, (String)source);){
            readContext.config(this.readerFeatureArray);
            ObjectReader objectReader = readContext.getProvider().getObjectReader(targetType);
            Object object = objectReader.readObject(reader, 0L);
            reader.handleResolveTasks(object);
            Object object2 = object;
            return (T)object2;
        }
        catch (Throwable th) {
            throw new ConvertException(this.getConverterName(), String.class.getName(), targetType.getTypeName(), th);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String parseToString(Object obj) {
        JSONWriter.Context writeContext = new JSONWriter.Context(this.writerProvider, this.writerFeatureArray);
        try (JSONWriter writer = JSONWriter.of((JSONWriter.Context)writeContext);){
            if (obj == null) {
                writer.writeNull();
            } else {
                Class<?> valueClass = obj.getClass();
                ObjectWriter objectWriter = writer.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, obj, null, null, 0L);
            }
            String string = writer.toString();
            return string;
        }
        catch (NullPointerException | NumberFormatException ex) {
            throw new JSONException("toJSONString error", (Throwable)ex);
        }
    }

    public String encode(Object source) {
        if (source instanceof CharSequence) {
            return source.toString();
        }
        try {
            return this.parseToString(source);
        }
        catch (Throwable th) {
            throw new ConvertException(this.getConverterName(), source.getClass().getName(), String.class.getName(), th);
        }
    }

    public boolean checkCanBeLoad() {
        try {
            Class.forName(FAST_JSON2_NAME);
            return true;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    public static boolean checkExistFastjson2Annotation(Class<?> cls) {
        return JavaBeanInfo.checkExistAnnotation(cls, FASTJSON_ANNOTATION_LIST);
    }
}

