/*
 * Decompiled with CFR 0.152.
 */
package com.chm.converter.xml;

import com.chm.converter.core.ClassInfoStorage;
import com.chm.converter.core.Converter;
import com.chm.converter.core.FieldInfo;
import com.chm.converter.core.JavaBeanInfo;
import com.chm.converter.core.reflect.TypeToken;
import com.chm.converter.core.utils.MapUtil;
import com.chm.converter.xml.annotation.XmlProperty;
import com.chm.converter.xml.annotation.XmlRootElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

public class XmlClassInfoStorage
implements ClassInfoStorage {
    public static final Map<TypeToken<?>, Map<Class<? extends Converter>, Boolean>> INIT_TABLE = MapUtil.newHashMap();
    public static final ClassInfoStorage INSTANCE = new XmlClassInfoStorage();

    public <T> void initClassInfo(TypeToken<T> typeToken, Class<? extends Converter> converterClass) {
        super.initClassInfo(typeToken, converterClass);
        JavaBeanInfo javaBeanInfo = (JavaBeanInfo)ClassInfoStorage.get((Map)BEAN_INFO_MAP, typeToken, converterClass);
        Class clazz = typeToken.getRawType();
        XmlRootElement xmlRootElement = clazz.getAnnotation(XmlRootElement.class);
        if (xmlRootElement != null) {
            String xmlRootName = xmlRootElement.name();
            String namespace = xmlRootElement.namespace();
            javaBeanInfo.putExpandProperty("xmlRootName", (Object)xmlRootName);
            javaBeanInfo.putExpandProperty("namespace", (Object)namespace);
        }
        List sortedFieldList = javaBeanInfo.getSortedFieldList();
        for (FieldInfo fieldInfo : sortedFieldList) {
            Method method;
            Field field = fieldInfo.getField();
            XmlProperty xmlProperty = null;
            if (field != null) {
                xmlProperty = field.getAnnotation(XmlProperty.class);
            }
            if (xmlProperty == null && (method = fieldInfo.getMethod()) != null) {
                xmlProperty = method.getAnnotation(XmlProperty.class);
            }
            if (xmlProperty == null) continue;
            boolean isCData = xmlProperty.isCData();
            boolean isAttribute = xmlProperty.isAttribute();
            boolean isText = xmlProperty.isText();
            String namespace = xmlProperty.namespace();
            fieldInfo.putExpandProperty("isCData", (Object)isCData);
            fieldInfo.putExpandProperty("isAttribute", (Object)isAttribute);
            fieldInfo.putExpandProperty("isText", (Object)isText);
            fieldInfo.putExpandProperty("namespace", (Object)namespace);
        }
        ClassInfoStorage.put(INIT_TABLE, typeToken, converterClass, (Object)true);
    }

    public <T> boolean isInit(TypeToken<T> type, Class<? extends Converter> converterClass) {
        return Boolean.TRUE.equals(ClassInfoStorage.get(INIT_TABLE, type, converterClass));
    }
}

