package io.gitee.declear.dec.cloud.common.config;

import io.gitee.declear.dec.cloud.common.property.HardWareInfoManager;
import io.gitee.declear.dec.cloud.common.remoting.resource.DecCloudLoadBalanceProcessor;
import io.gitee.declear.dec.cloud.common.remoting.resource.DecCloudResourceManager;
import io.gitee.declear.dec.cloud.common.remoting.DecRemoteContextManager;
import io.gitee.declear.dec.cloud.common.remoting.invoke.DecCloudInvoker;
import io.gitee.declear.dec.cloud.common.rpc.netty.NettyClient;
import io.gitee.declear.dec.cloud.common.rpc.netty.NettyGlobalResourceManager;
import io.gitee.declear.dec.cloud.common.rpc.netty.NettyServer;
import io.gitee.declear.dec.cloud.common.rpc.protocol.DecCloudProtocol;
import io.gitee.declear.dec.cloud.common.web.context.DecWebContextManager;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

/**
 * spring bean dec-cloud 框架内各种基本配置定义
 * @author DEC
 */
@Configuration
public class DecCloudConfiguration {

    @Bean(name = "nettyServer", initMethod = "init", destroyMethod = "shutdown")
    @Scope(ConfigurableBeanFactory.SCOPE_SINGLETON)
    public NettyServer generateNettyServer() {
        return new NettyServer();
    }

    @Bean(name = "nettyClient", initMethod = "init", destroyMethod = "shutdown")
    @Scope(ConfigurableBeanFactory.SCOPE_SINGLETON)
    public NettyClient generateNettyClient() {
        return new NettyClient();
    }

    @Bean(name = "nettyGlobalResourceManager", initMethod = "init", destroyMethod = "shutdown")
    @Scope(ConfigurableBeanFactory.SCOPE_SINGLETON)
    public NettyGlobalResourceManager generateNettyGlobalResourceManager() {
        return new NettyGlobalResourceManager();
    }

    @Bean(name = "decRemoteContextManager", initMethod = "init", destroyMethod = "shutdown")
    @Scope(ConfigurableBeanFactory.SCOPE_SINGLETON)
    public DecRemoteContextManager generateDecRemoteContextManager() {
        return new DecRemoteContextManager();
    }

    @Bean(name = "decCloudResourceManager", initMethod = "init", destroyMethod = "shutdown")
    @Scope(ConfigurableBeanFactory.SCOPE_SINGLETON)
    public DecCloudResourceManager generateDecCloudResourceManager(DecCloudLoadBalanceProcessor decCloudLoadBalanceProcessor) {
        DecCloudResourceManager decCloudResourceManager = new DecCloudResourceManager();
        decCloudResourceManager.setDecCloudLoadBalanceProcessor(decCloudLoadBalanceProcessor);
        return decCloudResourceManager;
    }

    @Bean(name = "hardWareInfoManager", initMethod = "init", destroyMethod = "shutdown")
    @Scope(ConfigurableBeanFactory.SCOPE_SINGLETON)
    public HardWareInfoManager generateHardWareInfoManager() {
        return new HardWareInfoManager();
    }

    @Bean(name = "decWebContextManager", initMethod = "init", destroyMethod = "shutdown")
    @Scope(ConfigurableBeanFactory.SCOPE_SINGLETON)
    public DecWebContextManager generateDecWebContextManager() {
        return new DecWebContextManager();
    }

    @Bean(name = "decCloudInvoker")
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    public DecCloudInvoker generateDecCloudInvoker() {
        return new DecCloudInvoker();
    }

    @Bean(name = "decCloudProtocol")
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    public DecCloudProtocol generateDecCloudProtocol() {
        return new DecCloudProtocol();
    }

}
