package io.gitee.declear.dec.cloud.common.config;

import io.gitee.declear.common.utils.CommonUtils;
import io.gitee.declear.common.utils.YmlUtils;
import io.gitee.declear.dec.cloud.common.constants.Constants;
import io.gitee.declear.dec.cloud.common.property.PropertiesManager;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

import java.util.Map;

/**
 * PropertiesManager spring bean 配置管理
 * @author DEC
 */
@Slf4j
@Configuration
public class PropertiesConfiguration implements ApplicationContextAware {

    private ApplicationContext applicationContext;

    @Bean(name = "propertiesManager", initMethod = "init", destroyMethod = "shutdown")
    @Scope(ConfigurableBeanFactory.SCOPE_SINGLETON)
    public PropertiesManager generatePropertiesManager() {
        Map<String, String> ymlProperties = YmlUtils.getProperties(Constants.DEC_CLOUD_YML_FILE);
        if(CommonUtils.isEmpty(ymlProperties.get(Constants.DEC_CLOUD_CONTEXT_PATH))) {
            log.error("dec.cloud.context-path have not configured in dec-cloud.yml. dec cloud service exit.");
            SpringApplication.exit(applicationContext);
        }
        if(CommonUtils.isEmpty(ymlProperties.get(Constants.DEC_CLOUD_INSTANCE_NAME))) {
            log.error("dec.cloud.instance have not configured in dec-cloud.yml. dec cloud service exit.");
            SpringApplication.exit(applicationContext);
        }
        if(CommonUtils.isEmpty(ymlProperties.get(Constants.DEC_CLOUD_PORT))) {
            log.error("dec.cloud.port have not configured in dec-cloud.yml. dec cloud service exit.");
            SpringApplication.exit(applicationContext);
        }
        return new PropertiesManager(ymlProperties);
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}
