package io.gitee.declear.dec.cloud.common.config.spring;

import io.gitee.declear.common.utils.CommonUtils;
import io.gitee.declear.dec.cloud.common.constants.Constants;
import io.gitee.declear.dec.cloud.common.exception.DecCloudServiceException;
import io.gitee.declear.dec.cloud.common.remoting.DecRemoteContext;
import io.gitee.declear.dec.cloud.common.remoting.invoke.DecCloudInvoker;
import io.gitee.declear.dec.cloud.common.remoting.resource.DecCloudResourceManager;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.ApplicationContext;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

/**
 * DecCloudService 注解 定义的外部接口的动态代理类
 * @author DEC
 */
@Slf4j
public class DecCloudServiceBean implements InvocationHandler {

    private ApplicationContext applicationContext;

    public DecCloudServiceBean(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        // java.lang.Object 原生方法默认处理
        if(Object.class.equals(method.getDeclaringClass())) {
            return method.invoke(this, args);
        }

        // 其他方法代理， 自定义处理
        return processDecCloudServiceMethod(proxy, method, args);
    }

    private DecRemoteContext<Serializable> processDecCloudServiceMethod(Object proxy, Method method, Object[] args) {
        DecCloudInvoker invoker = applicationContext.getBean(DecCloudInvoker.class);
        DecCloudResourceManager cloudResourceManager = applicationContext.getBean(DecCloudResourceManager.class);
        DecRemoteContext<Serializable> context = new DecRemoteContext<>();
        context.setId(CommonUtils.UUID());
        context.setType(Constants.DEC_CLOUD_CODE_PROTOCOL_TYPE_1);
        context.setCloudDestination(cloudResourceManager.getDecCloudApi(method));
        context.setCloudOrigin(cloudResourceManager.getCloudOrigin());
        List<Serializable> paramList = new ArrayList<>();
        for (Object arg : args) {
            if(!(arg instanceof Serializable)) {
                log.error("{}#{} should define Serializable parameter.", method.getDeclaringClass(), method.getName());
                throw new DecCloudServiceException("Method which marked by @DecCloudOutBound and @DecCloudInBound should define Serializable parameter.");
            }
            paramList.add((Serializable) arg);
        }
        context.setParamList(paramList);

        invoker.invoke(context);
        return null;
    }

}
