package io.gitee.declear.dec.cloud.common.config.spring;

import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;

import java.lang.reflect.Proxy;

/**
 * DecCloudService 注解 定义的外部接口的动态代理类的工厂类
 * @author DEC
 */
public class DecCloudServiceBeanFactory<T> implements FactoryBean<T> {

    private Class<T> interfaceType;

    private ApplicationContext applicationContext;

    public DecCloudServiceBeanFactory(Class<T> interfaceType, ApplicationContext applicationContext) {
        this.interfaceType = interfaceType;
        this.applicationContext = applicationContext;
    }

    @Override
    public T getObject() throws Exception {
        return (T) Proxy.newProxyInstance(interfaceType.getClassLoader(), new Class[]{ interfaceType }, new DecCloudServiceBean(applicationContext));
    }

    @Override
    public Class<?> getObjectType() {
        return interfaceType;
    }
}
